/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql;

import java.sql.CallableStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.internal.CoreLogging;
import org.hibernate.sql.JdbcValueExtractor;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;
import org.hibernate.type.descriptor.sql.spi.JdbcTypeNameMapper;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;
import org.jboss.logging.Logger;

public abstract class AbstractJdbcValueExtractor<J>
implements JdbcValueExtractor<J> {
    private static final Logger log = CoreLogging.logger(AbstractJdbcValueExtractor.class);
    private final JavaTypeDescriptor<J> javaDescriptor;
    private final SqlTypeDescriptor sqlDescriptor;

    public AbstractJdbcValueExtractor(JavaTypeDescriptor<J> javaDescriptor, SqlTypeDescriptor sqlDescriptor) {
        this.javaDescriptor = javaDescriptor;
        this.sqlDescriptor = sqlDescriptor;
    }

    public JavaTypeDescriptor<J> getJavaDescriptor() {
        return this.javaDescriptor;
    }

    public SqlTypeDescriptor getSqlDescriptor() {
        return this.sqlDescriptor;
    }

    @Override
    public J extract(ResultSet rs, int position, ExecutionContext executionContext) throws SQLException {
        J value = this.doExtract(rs, position, executionContext);
        boolean traceEnabled = log.isTraceEnabled();
        if (value == null || rs.wasNull()) {
            if (traceEnabled) {
                log.tracef("extracted value ([%s] : [%s]) - [null]", position, (Object)JdbcTypeNameMapper.getTypeName(this.getSqlDescriptor().getJdbcTypeCode()));
            }
            return null;
        }
        if (traceEnabled) {
            log.tracef("extracted value ([%s] : [%s]) - [%s]", position, (Object)JdbcTypeNameMapper.getTypeName(this.getSqlDescriptor().getJdbcTypeCode()), (Object)this.getJavaDescriptor().extractLoggableRepresentation(value));
        }
        return value;
    }

    protected abstract J doExtract(ResultSet var1, int var2, ExecutionContext var3) throws SQLException;

    @Override
    public J extract(CallableStatement statement, int index, ExecutionContext executionContext) throws SQLException {
        J value = this.doExtract(statement, index, executionContext);
        boolean traceEnabled = log.isTraceEnabled();
        if (value == null || statement.wasNull()) {
            if (traceEnabled) {
                log.tracef("extracted procedure output  parameter ([%s] : [%s]) - [null]", index, (Object)JdbcTypeNameMapper.getTypeName(this.getSqlDescriptor().getJdbcTypeCode()));
            }
            return null;
        }
        if (traceEnabled) {
            log.tracef("extracted procedure output  parameter ([%s] : [%s]) - [%s]", index, (Object)JdbcTypeNameMapper.getTypeName(this.getSqlDescriptor().getJdbcTypeCode()), (Object)this.getJavaDescriptor().extractLoggableRepresentation(value));
        }
        return value;
    }

    protected abstract J doExtract(CallableStatement var1, int var2, ExecutionContext var3) throws SQLException;

    @Override
    public J extract(CallableStatement statement, String jdbcParameterName, ExecutionContext executionContext) throws SQLException {
        J value = this.doExtract(statement, jdbcParameterName, executionContext);
        boolean traceEnabled = log.isTraceEnabled();
        if (value == null || statement.wasNull()) {
            if (traceEnabled) {
                log.tracef("extracted named procedure output  parameter ([%s] : [%s]) - [null]", (Object)jdbcParameterName, (Object)JdbcTypeNameMapper.getTypeName(this.getSqlDescriptor().getJdbcTypeCode()));
            }
            return null;
        }
        if (traceEnabled) {
            log.tracef("extracted named procedure output  parameter ([%s] : [%s]) - [%s]", (Object)jdbcParameterName, (Object)JdbcTypeNameMapper.getTypeName(this.getSqlDescriptor().getJdbcTypeCode()), (Object)this.getJavaDescriptor().extractLoggableRepresentation(value));
        }
        return value;
    }

    protected abstract J doExtract(CallableStatement var1, String var2, ExecutionContext var3) throws SQLException;
}

