/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.consume.spi;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.SortOrder;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.internal.util.collections.StandardStack;
import org.hibernate.metamodel.model.domain.spi.DiscriminatorDescriptor;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.query.QueryLiteralRendering;
import org.hibernate.query.UnaryArithmeticOperator;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.consume.spi.SelfRenderingExpression;
import org.hibernate.sql.ast.consume.spi.SqlAppender;
import org.hibernate.sql.ast.consume.spi.SqlAstWalker;
import org.hibernate.sql.ast.produce.SqlTreeException;
import org.hibernate.sql.ast.produce.spi.SqlSelectionExpression;
import org.hibernate.sql.ast.tree.expression.AbsFunction;
import org.hibernate.sql.ast.tree.expression.AvgFunction;
import org.hibernate.sql.ast.tree.expression.BinaryArithmeticExpression;
import org.hibernate.sql.ast.tree.expression.BitLengthFunction;
import org.hibernate.sql.ast.tree.expression.CaseSearchedExpression;
import org.hibernate.sql.ast.tree.expression.CaseSimpleExpression;
import org.hibernate.sql.ast.tree.expression.CastFunction;
import org.hibernate.sql.ast.tree.expression.CoalesceFunction;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.ConcatFunction;
import org.hibernate.sql.ast.tree.expression.CountFunction;
import org.hibernate.sql.ast.tree.expression.CountStarFunction;
import org.hibernate.sql.ast.tree.expression.CurrentDateFunction;
import org.hibernate.sql.ast.tree.expression.CurrentTimeFunction;
import org.hibernate.sql.ast.tree.expression.CurrentTimestampFunction;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.ExtractFunction;
import org.hibernate.sql.ast.tree.expression.GenericParameter;
import org.hibernate.sql.ast.tree.expression.LengthFunction;
import org.hibernate.sql.ast.tree.expression.LocateFunction;
import org.hibernate.sql.ast.tree.expression.LowerFunction;
import org.hibernate.sql.ast.tree.expression.MaxFunction;
import org.hibernate.sql.ast.tree.expression.MinFunction;
import org.hibernate.sql.ast.tree.expression.ModFunction;
import org.hibernate.sql.ast.tree.expression.NamedParameter;
import org.hibernate.sql.ast.tree.expression.NonStandardFunction;
import org.hibernate.sql.ast.tree.expression.NullifFunction;
import org.hibernate.sql.ast.tree.expression.PositionalParameter;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.expression.SqrtFunction;
import org.hibernate.sql.ast.tree.expression.SubstrFunction;
import org.hibernate.sql.ast.tree.expression.SumFunction;
import org.hibernate.sql.ast.tree.expression.TrimFunction;
import org.hibernate.sql.ast.tree.expression.UnaryOperation;
import org.hibernate.sql.ast.tree.expression.UpperFunction;
import org.hibernate.sql.ast.tree.expression.domain.EntityTypeLiteral;
import org.hibernate.sql.ast.tree.from.FromClause;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.predicate.BetweenPredicate;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.FilterPredicate;
import org.hibernate.sql.ast.tree.predicate.GroupedPredicate;
import org.hibernate.sql.ast.tree.predicate.InListPredicate;
import org.hibernate.sql.ast.tree.predicate.InSubQueryPredicate;
import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.ast.tree.predicate.LikePredicate;
import org.hibernate.sql.ast.tree.predicate.NegatedPredicate;
import org.hibernate.sql.ast.tree.predicate.NullnessPredicate;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.predicate.SelfRenderingPredicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.ast.tree.sort.SortSpecification;
import org.hibernate.sql.exec.internal.JdbcParametersImpl;
import org.hibernate.sql.exec.spi.JdbcParameter;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;
import org.hibernate.sql.results.internal.EmptySqlSelection;
import org.hibernate.sql.results.spi.SqlSelection;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.descriptor.spi.SqlTypeDescriptorIndicators;
import org.hibernate.type.descriptor.sql.spi.JdbcLiteralFormatter;
import org.hibernate.type.spi.TypeConfiguration;

public abstract class AbstractSqlAstWalker
implements SqlAstWalker,
SqlTypeDescriptorIndicators {
    private final SessionFactoryImplementor sessionFactory;
    private final SqlAppender sqlAppender = this::appendSql;
    private final StringBuilder sqlBuffer = new StringBuilder();
    private final List<JdbcParameterBinder> parameterBinders = new ArrayList<JdbcParameterBinder>();
    private final JdbcParametersImpl jdbcParameters = new JdbcParametersImpl();
    private final Stack<Clause> clauseStack = new StandardStack<Clause>();

    protected AbstractSqlAstWalker(SessionFactoryImplementor sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    public String getSql() {
        return this.sqlBuffer.toString();
    }

    public List<JdbcParameterBinder> getParameterBinders() {
        return this.parameterBinders;
    }

    protected SqlAppender getSqlAppender() {
        return this.sqlAppender;
    }

    protected void appendSql(String fragment) {
        this.sqlBuffer.append(fragment);
    }

    protected JdbcServices getJdbcServices() {
        return this.getSessionFactory().getJdbcServices();
    }

    protected boolean isCurrentlyInPredicate() {
        return this.clauseStack.getCurrent() == Clause.WHERE || this.clauseStack.getCurrent() == Clause.HAVING;
    }

    protected Stack<Clause> getClauseStack() {
        return this.clauseStack;
    }

    @Override
    public void visitQuerySpec(QuerySpec querySpec) {
        List<SortSpecification> sortSpecifications;
        if (!querySpec.isRoot()) {
            this.appendSql(" (");
        }
        this.visitSelectClause(querySpec.getSelectClause());
        this.visitFromClause(querySpec.getFromClause());
        if (querySpec.getWhereClauseRestrictions() != null && !querySpec.getWhereClauseRestrictions().isEmpty()) {
            this.appendSql(" where ");
            this.clauseStack.push(Clause.WHERE);
            try {
                querySpec.getWhereClauseRestrictions().accept(this);
            }
            finally {
                this.clauseStack.pop();
            }
        }
        if ((sortSpecifications = querySpec.getSortSpecifications()) != null && !sortSpecifications.isEmpty()) {
            this.appendSql(" order by ");
            String separator = "";
            for (SortSpecification sortSpecification : sortSpecifications) {
                this.appendSql(separator);
                this.visitSortSpecification(sortSpecification);
                separator = ", ";
            }
        }
        this.visitLimitOffsetClause(querySpec);
        if (!querySpec.isRoot()) {
            this.appendSql(") ");
        }
    }

    @Override
    public void visitSortSpecification(SortSpecification sortSpecification) {
        SortOrder sortOrder;
        sortSpecification.getSortExpression().accept(this);
        String collation = sortSpecification.getCollation();
        if (collation != null) {
            this.appendSql(" collate ");
            this.appendSql(collation);
        }
        if ((sortOrder = sortSpecification.getSortOrder()) == SortOrder.ASCENDING) {
            this.appendSql(" asc");
        } else if (sortOrder == SortOrder.DESCENDING) {
            this.appendSql(" desc");
        }
    }

    @Override
    public void visitLimitOffsetClause(QuerySpec querySpec) {
        if (querySpec.getOffsetClauseExpression() != null) {
            this.appendSql(" offset ");
            querySpec.getOffsetClauseExpression().accept(this);
            this.appendSql(" rows");
        }
        if (querySpec.getLimitClauseExpression() != null) {
            this.appendSql(" fetch first ");
            querySpec.getLimitClauseExpression().accept(this);
            this.appendSql(" rows only");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void visitSelectClause(SelectClause selectClause) {
        this.clauseStack.push(Clause.SELECT);
        try {
            this.appendSql("select ");
            if (selectClause.isDistinct()) {
                this.appendSql("distinct ");
            }
            String separator = "";
            for (SqlSelection sqlSelection : selectClause.getSqlSelections()) {
                if (sqlSelection instanceof EmptySqlSelection) continue;
                this.appendSql(separator);
                sqlSelection.accept(this);
                separator = ", ";
            }
        }
        finally {
            this.clauseStack.pop();
        }
    }

    @Override
    public void visitSqlSelection(SqlSelection sqlSelection) {
    }

    @Override
    public void visitFromClause(FromClause fromClause) {
        this.appendSql(" from ");
        String separator = "";
        for (TableGroup root : fromClause.getRoots()) {
            this.appendSql(separator);
            this.visitRoot(root);
            separator = ", ";
        }
    }

    protected void visitRoot(TableGroup root) {
        this.visitTableGroup(root);
        this.consumeJoins(root);
    }

    private void consumeJoins(TableGroup tableGroup) {
        tableGroup.visitTableGroupJoins(this::visitTableGroupJoin);
    }

    @Override
    public void visitTableGroup(TableGroup tableGroup) {
        tableGroup.render(this.sqlAppender, this);
    }

    @Override
    public void visitTableGroupJoin(TableGroupJoin tableGroupJoin) {
        TableGroup joinedGroup = tableGroupJoin.getJoinedGroup();
        this.appendSql(" ");
        this.appendSql(tableGroupJoin.getJoinType().getText());
        this.appendSql(" join (");
        this.visitTableGroup(joinedGroup);
        this.appendSql(")");
        this.clauseStack.push(Clause.WHERE);
        try {
            if (tableGroupJoin.getPredicate() != null && !tableGroupJoin.getPredicate().isEmpty()) {
                this.appendSql(" on ");
                tableGroupJoin.getPredicate().accept(this);
            }
        }
        finally {
            this.clauseStack.pop();
        }
        joinedGroup.visitTableGroupJoins(this::visitTableGroupJoin);
    }

    @Override
    public void visitTableReference(TableReference tableReference) {
    }

    @Override
    public void visitTableReferenceJoin(TableReferenceJoin tableReferenceJoin) {
    }

    @Override
    public void visitColumnReference(ColumnReference columnReference) {
        this.appendSql(columnReference.renderSqlFragment());
    }

    @Override
    public void visitNonStandardFunctionExpression(NonStandardFunction function) {
        this.appendSql(function.getFunctionName());
        if (!function.getArguments().isEmpty()) {
            this.appendSql("(");
            String separator = "";
            for (Expression argumentExpression : function.getArguments()) {
                this.appendSql(separator);
                argumentExpression.accept(this);
                separator = ", ";
            }
            this.appendSql(")");
        }
    }

    @Override
    public void visitAbsFunction(AbsFunction function) {
        this.appendSql("abs(");
        function.getArgument().accept(this);
        this.appendSql(")");
    }

    @Override
    public void visitAvgFunction(AvgFunction function) {
        this.appendSql("avg(");
        function.getArgument().accept(this);
        this.appendSql(")");
    }

    @Override
    public void visitBitLengthFunction(BitLengthFunction function) {
        this.appendSql("bit_length(");
        function.getArgument().accept(this);
        this.appendSql(")");
    }

    @Override
    public void visitCastFunction(CastFunction function) {
        this.sqlAppender.appendSql("cast(");
        function.getExpressionToCast().accept(this);
        this.sqlAppender.appendSql(" as ");
        this.sqlAppender.appendSql(this.determineCastTargetTypeSqlExpression(function));
        this.sqlAppender.appendSql(")");
    }

    private String determineCastTargetTypeSqlExpression(CastFunction castFunction) {
        if (castFunction.getExplicitCastTargetTypeSqlExpression() != null) {
            return castFunction.getExplicitCastTargetTypeSqlExpression();
        }
        SqlExpressableType castResultType = castFunction.getCastResultType();
        if (castResultType == null) {
            throw new SqlTreeException("CastFunction did not define an explicit cast target SQL expression and its return type was null");
        }
        BasicJavaDescriptor javaTypeDescriptor = castResultType.getJavaTypeDescriptor();
        return this.getJdbcServices().getDialect().getCastTypeName(javaTypeDescriptor.getJdbcRecommendedSqlType(this).getJdbcTypeCode());
    }

    @Override
    public void visitConcatFunction(ConcatFunction function) {
        this.appendSql("concat(");
        boolean firstPass = true;
        for (Expression expression : function.getExpressions()) {
            if (!firstPass) {
                this.appendSql(", ");
            }
            expression.accept(this);
            firstPass = false;
        }
        this.appendSql(")");
    }

    @Override
    public void visitSubstrFunction(SubstrFunction function) {
        this.appendSql("substr(");
        boolean firstPass = true;
        for (Expression expression : function.getExpressions()) {
            if (!firstPass) {
                this.appendSql(", ");
            }
            expression.accept(this);
            firstPass = false;
        }
        this.appendSql(")");
    }

    @Override
    public void visitCountFunction(CountFunction function) {
        this.appendSql("count(");
        if (function.isDistinct()) {
            this.appendSql("distinct ");
        }
        function.getArgument().accept(this);
        this.appendSql(")");
    }

    @Override
    public void visitCountStarFunction(CountStarFunction function) {
        this.appendSql("count(");
        if (function.isDistinct()) {
            this.appendSql("distinct ");
        }
        this.appendSql("*)");
    }

    @Override
    public void visitCurrentDateFunction(CurrentDateFunction function) {
        this.appendSql("current_date");
    }

    @Override
    public void visitCurrentTimeFunction(CurrentTimeFunction function) {
        this.appendSql("current_time");
    }

    @Override
    public void visitCurrentTimestampFunction(CurrentTimestampFunction function) {
        this.appendSql("current_timestamp");
    }

    @Override
    public void visitTuple(SqlTuple tuple) {
        boolean isCurrentWhereClause;
        List<Expression> expressions = tuple.getExpressions();
        String separator = "";
        boolean bl = isCurrentWhereClause = this.clauseStack.getCurrent() == Clause.WHERE;
        if (isCurrentWhereClause) {
            this.appendSql("(");
        }
        for (Expression expression : expressions) {
            this.appendSql(separator);
            expression.accept(this);
            separator = ", ";
        }
        if (isCurrentWhereClause) {
            this.appendSql(")");
        }
    }

    @Override
    public void visitExtractFunction(ExtractFunction extractFunction) {
        this.appendSql("extract(");
        extractFunction.getUnitToExtract().accept(this);
        this.appendSql(" from ");
        extractFunction.getExtractionSource().accept(this);
        this.appendSql(")");
    }

    @Override
    public void visitLengthFunction(LengthFunction function) {
        this.sqlAppender.appendSql("length(");
        function.getArgument().accept(this);
        this.sqlAppender.appendSql(")");
    }

    @Override
    public void visitLocateFunction(LocateFunction function) {
        this.appendSql("locate(");
        function.getPatternString().accept(this);
        this.appendSql(", ");
        function.getStringToSearch().accept(this);
        if (function.getStartPosition() != null) {
            this.appendSql(", ");
            function.getStartPosition().accept(this);
        }
        this.appendSql(")");
    }

    @Override
    public void visitLowerFunction(LowerFunction function) {
        this.appendSql("lower(");
        function.getArgument().accept(this);
        this.appendSql(")");
    }

    @Override
    public void visitMaxFunction(MaxFunction function) {
        this.appendSql("max(");
        if (function.isDistinct()) {
            this.appendSql("distinct ");
        }
        function.getArgument().accept(this);
        this.appendSql(")");
    }

    @Override
    public void visitMinFunction(MinFunction function) {
        this.appendSql("min(");
        if (function.isDistinct()) {
            this.appendSql("distinct ");
        }
        function.getArgument().accept(this);
        this.appendSql(")");
    }

    @Override
    public void visitModFunction(ModFunction function) {
        this.sqlAppender.appendSql("mod(");
        function.getDividend().accept(this);
        this.sqlAppender.appendSql(", ");
        function.getDivisor().accept(this);
        this.sqlAppender.appendSql(")");
    }

    @Override
    public void visitSqrtFunction(SqrtFunction function) {
        this.appendSql("sqrt(");
        function.getArgument().accept(this);
        this.appendSql(")");
    }

    @Override
    public void visitSumFunction(SumFunction function) {
        this.appendSql("sum(");
        if (function.isDistinct()) {
            this.appendSql("distinct ");
        }
        function.getArgument().accept(this);
        this.appendSql(")");
    }

    @Override
    public void visitTrimFunction(TrimFunction function) {
        this.sqlAppender.appendSql("trim(");
        this.sqlAppender.appendSql(function.getSpecification().toSqlText());
        this.sqlAppender.appendSql(" ");
        function.getTrimCharacter().accept(this);
        this.sqlAppender.appendSql(" from ");
        function.getSource().accept(this);
        this.sqlAppender.appendSql(")");
    }

    @Override
    public void visitUpperFunction(UpperFunction function) {
        this.appendSql("upper(");
        function.getArgument().accept(this);
        this.appendSql(")");
    }

    @Override
    public void visitSqlSelectionExpression(SqlSelectionExpression expression) {
        boolean useSelectionPosition = this.getSessionFactory().getJdbcServices().getDialect().replaceResultVariableInOrderByClauseWithPosition();
        if (useSelectionPosition) {
            this.appendSql(Integer.toString(expression.getSelection().getJdbcResultSetIndex()));
        } else {
            expression.getExpression().accept(this);
        }
    }

    @Override
    public void visitEntityTypeLiteral(EntityTypeLiteral expression) {
        EntityTypeDescriptor<?> referencedSubType = expression.getEntityTypeDescriptor();
        DiscriminatorDescriptor<?> discriminatorDescriptor = expression.getDiscriminatorDescriptor();
        Object discriminatorValue = discriminatorDescriptor.getDiscriminatorMappings().entityNameToDiscriminatorValue(referencedSubType.getEntityName());
        this.appendSql(discriminatorValue.toString());
    }

    @Override
    public void visitBinaryArithmeticExpression(BinaryArithmeticExpression arithmeticExpression) {
        arithmeticExpression.getLeftHandOperand().accept(this);
        this.appendSql(arithmeticExpression.getOperator().getOperatorSqlTextString());
        arithmeticExpression.getRightHandOperand().accept(this);
    }

    @Override
    public void visitCaseSearchedExpression(CaseSearchedExpression caseSearchedExpression) {
        this.appendSql("case ");
        for (CaseSearchedExpression.WhenFragment whenFragment : caseSearchedExpression.getWhenFragments()) {
            this.appendSql(" when ");
            whenFragment.getPredicate().accept(this);
            this.appendSql(" then ");
            whenFragment.getResult().accept(this);
        }
        this.appendSql(" else ");
        caseSearchedExpression.getOtherwise().accept(this);
        this.appendSql(" end");
    }

    @Override
    public void visitCaseSimpleExpression(CaseSimpleExpression caseSimpleExpression) {
        this.appendSql("case ");
        caseSimpleExpression.getFixture().accept(this);
        for (CaseSimpleExpression.WhenFragment whenFragment : caseSimpleExpression.getWhenFragments()) {
            this.appendSql(" when ");
            whenFragment.getCheckValue().accept(this);
            this.appendSql(" then ");
            whenFragment.getResult().accept(this);
        }
        this.appendSql(" else ");
        caseSimpleExpression.getOtherwise().accept(this);
        this.appendSql(" end");
    }

    @Override
    public void visitCoalesceFunction(CoalesceFunction coalesceExpression) {
        this.appendSql("coalesce(");
        String separator = "";
        for (Expression expression : coalesceExpression.getValues()) {
            this.appendSql(separator);
            expression.accept(this);
            separator = ", ";
        }
        this.appendSql(")");
    }

    @Override
    public void visitGenericParameter(GenericParameter parameter) {
        this.visitJdbcParameterBinder(parameter.getParameterBinder());
        if (parameter instanceof JdbcParameter) {
            this.jdbcParameters.addParameter((JdbcParameter)((Object)parameter));
        }
    }

    protected void visitJdbcParameterBinder(JdbcParameterBinder jdbcParameterBinder) {
        this.parameterBinders.add(jdbcParameterBinder);
        this.appendSql("?");
    }

    @Override
    public void visitNamedParameter(NamedParameter namedParameter) {
        this.visitJdbcParameterBinder(namedParameter);
    }

    @Override
    public void visitPositionalParameter(PositionalParameter positionalParameter) {
        this.visitJdbcParameterBinder(positionalParameter);
    }

    @Override
    public void visitQueryLiteral(QueryLiteral queryLiteral) {
        QueryLiteralRendering queryLiteralRendering = this.getSessionFactory().getSessionFactoryOptions().getQueryLiteralRendering();
        switch (queryLiteralRendering) {
            case AS_LITERAL: {
                this.renderAsLiteral(queryLiteral);
                break;
            }
            case AS_PARAM: {
                this.visitJdbcParameterBinder(queryLiteral);
                break;
            }
            case AS_PARAM_OUTSIDE_SELECT: {
                if (queryLiteral.isInSelect()) {
                    this.renderAsLiteral(queryLiteral);
                    break;
                }
                this.visitJdbcParameterBinder(queryLiteral);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unrecognized QueryLiteralRendering : " + (Object)((Object)queryLiteralRendering));
            }
        }
    }

    private void renderAsLiteral(QueryLiteral queryLiteral) {
        if (queryLiteral.getValue() == null) {
            this.appendSql("NULL");
        } else {
            JdbcLiteralFormatter<Object> jdbcLiteralFormatter = queryLiteral.getType().getSqlTypeDescriptor().getJdbcLiteralFormatter(queryLiteral.getType().getJavaTypeDescriptor());
            this.appendSql(jdbcLiteralFormatter.toJdbcLiteral(queryLiteral.getValue(), this.sessionFactory.getJdbcServices().getJdbcEnvironment().getDialect(), null));
        }
    }

    @Override
    public void visitNullifFunction(NullifFunction function) {
        this.appendSql("nullif(");
        function.getFirstArgument().accept(this);
        this.appendSql(", ");
        function.getSecondArgument().accept(this);
        this.appendSql(")");
    }

    @Override
    public void visitUnaryOperationExpression(UnaryOperation unaryOperationExpression) {
        if (unaryOperationExpression.getOperator() == UnaryArithmeticOperator.UNARY_PLUS) {
            this.appendSql("+");
        } else {
            this.appendSql("-");
        }
        unaryOperationExpression.getOperand().accept(this);
    }

    @Override
    public void visitSelfRenderingPredicate(SelfRenderingPredicate selfRenderingPredicate) {
        selfRenderingPredicate.getSelfRenderingExpression().accept(this);
    }

    @Override
    public void visitSelfRenderingExpression(SelfRenderingExpression expression) {
        expression.renderToSql(this.sqlAppender, this, this.getSessionFactory());
    }

    @Override
    public void visitBetweenPredicate(BetweenPredicate betweenPredicate) {
        betweenPredicate.getExpression().accept(this);
        if (betweenPredicate.isNegated()) {
            this.appendSql(" not");
        }
        this.appendSql(" between ");
        betweenPredicate.getLowerBound().accept(this);
        this.appendSql(" and ");
        betweenPredicate.getUpperBound().accept(this);
    }

    @Override
    public void visitFilterPredicate(FilterPredicate filterPredicate) {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public void visitGroupedPredicate(GroupedPredicate groupedPredicate) {
        if (groupedPredicate.isEmpty()) {
            return;
        }
        this.appendSql("(");
        groupedPredicate.getSubPredicate().accept(this);
        this.appendSql(")");
    }

    @Override
    public void visitInListPredicate(InListPredicate inListPredicate) {
        inListPredicate.getTestExpression().accept(this);
        if (inListPredicate.isNegated()) {
            this.appendSql(" not");
        }
        this.appendSql(" in (");
        if (inListPredicate.getListExpressions().isEmpty()) {
            this.appendSql("null");
        } else {
            String separator = "";
            for (Expression expression : inListPredicate.getListExpressions()) {
                this.appendSql(separator);
                expression.accept(this);
                separator = ", ";
            }
        }
        this.appendSql(")");
    }

    @Override
    public void visitInSubQueryPredicate(InSubQueryPredicate inSubQueryPredicate) {
        inSubQueryPredicate.getTestExpression().accept(this);
        if (inSubQueryPredicate.isNegated()) {
            this.appendSql(" not");
        }
        this.appendSql(" in ");
        this.visitQuerySpec(inSubQueryPredicate.getSubQuery());
    }

    @Override
    public void visitJunction(Junction junction) {
        if (junction.isEmpty()) {
            return;
        }
        String separator = "";
        for (Predicate predicate : junction.getPredicates()) {
            this.appendSql(separator);
            predicate.accept(this);
            separator = junction.getNature() == Junction.Nature.CONJUNCTION ? " and " : " or ";
        }
    }

    @Override
    public void visitLikePredicate(LikePredicate likePredicate) {
        likePredicate.getMatchExpression().accept(this);
        if (likePredicate.isNegated()) {
            this.appendSql(" not");
        }
        this.appendSql(" like ");
        likePredicate.getPattern().accept(this);
        if (likePredicate.getEscapeCharacter() != null) {
            this.appendSql(" escape ");
            likePredicate.getEscapeCharacter().accept(this);
        }
    }

    @Override
    public void visitNegatedPredicate(NegatedPredicate negatedPredicate) {
        if (negatedPredicate.isEmpty()) {
            return;
        }
        this.appendSql("not(");
        negatedPredicate.getPredicate().accept(this);
        this.appendSql(")");
    }

    @Override
    public void visitNullnessPredicate(NullnessPredicate nullnessPredicate) {
        nullnessPredicate.getExpression().accept(this);
        if (nullnessPredicate.isNegated()) {
            this.appendSql(" is not null");
        } else {
            this.appendSql(" is null");
        }
    }

    @Override
    public void visitRelationalPredicate(ComparisonPredicate comparisonPredicate) {
        comparisonPredicate.getLeftHandExpression().accept(this);
        this.appendSql(comparisonPredicate.getOperator().sqlText());
        comparisonPredicate.getRightHandExpression().accept(this);
    }

    @Override
    public boolean isNationalized() {
        return false;
    }

    @Override
    public boolean isLob() {
        return false;
    }

    @Override
    public TypeConfiguration getTypeConfiguration() {
        return this.getSessionFactory().getTypeConfiguration();
    }

    @Override
    public SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }
}

