/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.consume.spi;

import java.util.List;
import java.util.Set;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.model.relational.spi.PhysicalTable;
import org.hibernate.sql.ast.consume.spi.AbstractSqlAstToJdbcOperationConverter;
import org.hibernate.sql.ast.consume.spi.SqlMutationToJdbcMutationConverter;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.insert.InsertStatement;
import org.hibernate.sql.exec.spi.JdbcInsert;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;

public class InsertToJdbcInsertConverter
extends AbstractSqlAstToJdbcOperationConverter
implements SqlMutationToJdbcMutationConverter {
    public static JdbcInsert createJdbcInsert(InsertStatement sqlAst, SessionFactoryImplementor sessionFactory) {
        final InsertToJdbcInsertConverter walker = new InsertToJdbcInsertConverter(sessionFactory);
        walker.processStatement(sqlAst);
        return new JdbcInsert(){

            @Override
            public boolean isKeyGenerationEnabled() {
                return false;
            }

            @Override
            public String getSql() {
                return walker.getSql();
            }

            @Override
            public List<JdbcParameterBinder> getParameterBinders() {
                return walker.getParameterBinders();
            }

            @Override
            public Set<String> getAffectedTableNames() {
                return walker.getAffectedTableNames();
            }
        };
    }

    public InsertToJdbcInsertConverter(SessionFactoryImplementor sessionFactory) {
        super(sessionFactory);
    }

    private void processStatement(InsertStatement sqlAst) {
        this.appendSql("insert into ");
        PhysicalTable targetTable = (PhysicalTable)sqlAst.getTargetTable().getTable();
        String tableName = this.getSessionFactory().getJdbcServices().getJdbcEnvironment().getQualifiedObjectNameFormatter().format(targetTable.getQualifiedTableName(), this.getSessionFactory().getJdbcServices().getJdbcEnvironment().getDialect());
        this.appendSql(tableName);
        this.appendSql(" (");
        boolean firstPass = true;
        for (ColumnReference columnReference : sqlAst.getTargetColumnReferences()) {
            if (firstPass) {
                firstPass = false;
            } else {
                this.appendSql(", ");
            }
            this.visitColumnReference(columnReference);
        }
        this.appendSql(") values (");
        firstPass = true;
        for (Expression expression : sqlAst.getValues()) {
            if (firstPass) {
                firstPass = false;
            } else {
                this.appendSql(", ");
            }
            expression.accept(this);
        }
        this.appendSql(")");
    }
}

