/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.consume.spi;

import java.util.Collections;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.sql.ast.consume.SqlAstPrinter;
import org.hibernate.sql.ast.consume.spi.AbstractSqlAstToJdbcOperationConverter;
import org.hibernate.sql.ast.consume.spi.SqlSelectAstWalker;
import org.hibernate.sql.ast.produce.spi.SqlAstSelectDescriptor;
import org.hibernate.sql.ast.tree.SqlAstTreeLogger;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.JdbcSelectImpl;
import org.hibernate.sql.exec.internal.StandardResultSetMappingDescriptor;
import org.hibernate.sql.exec.spi.JdbcSelect;
import org.hibernate.type.descriptor.spi.SqlTypeDescriptorIndicators;

public class SqlAstSelectToJdbcSelectConverter
extends AbstractSqlAstToJdbcOperationConverter
implements SqlSelectAstWalker,
SqlTypeDescriptorIndicators {
    public static JdbcSelect interpret(QuerySpec querySpec, SessionFactoryImplementor sessionFactory) {
        SqlAstSelectToJdbcSelectConverter walker = new SqlAstSelectToJdbcSelectConverter(sessionFactory);
        walker.visitQuerySpec(querySpec);
        return new JdbcSelectImpl(walker.getSql(), walker.getParameterBinders(), new StandardResultSetMappingDescriptor(querySpec.getSelectClause().getSqlSelections(), Collections.emptyList()), walker.getAffectedTableNames());
    }

    public static JdbcSelect interpret(SqlAstSelectDescriptor sqlSelectPlan, SessionFactoryImplementor sessionFactory) {
        SelectStatement sqlAstStatement = sqlSelectPlan.getSqlAstStatement();
        if (SqlAstTreeLogger.DEBUG_ENABLED) {
            SqlAstPrinter.print(sqlAstStatement);
        }
        SqlAstSelectToJdbcSelectConverter walker = new SqlAstSelectToJdbcSelectConverter(sessionFactory);
        walker.visitSelectQuery(sqlAstStatement);
        return new JdbcSelectImpl(walker.getSql(), walker.getParameterBinders(), new StandardResultSetMappingDescriptor(sqlAstStatement.getQuerySpec().getSelectClause().getSqlSelections(), sqlSelectPlan.getQueryResults()), sqlSelectPlan.getAffectedTableNames());
    }

    private SqlAstSelectToJdbcSelectConverter(SessionFactoryImplementor sessionFactory) {
        super(sessionFactory);
    }

    @Override
    public void visitSelectQuery(SelectStatement selectQuery) {
        this.visitQuerySpec(selectQuery.getQuerySpec());
    }
}

