/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.consume.spi;

import java.util.List;
import java.util.Set;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.sql.ast.consume.SyntaxException;
import org.hibernate.sql.ast.consume.spi.AbstractSqlAstToJdbcOperationConverter;
import org.hibernate.sql.ast.consume.spi.SqlMutationToJdbcMutationConverter;
import org.hibernate.sql.ast.tree.insert.InsertSelectStatement;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.exec.spi.JdbcInsertSelect;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;

public class SqlInsertSelectToJdbcInsertSelectConverter
extends AbstractSqlAstToJdbcOperationConverter
implements SqlMutationToJdbcMutationConverter {
    public static JdbcInsertSelect interpret(InsertSelectStatement sqlAst, SessionFactoryImplementor sessionFactory) {
        final SqlInsertSelectToJdbcInsertSelectConverter walker = new SqlInsertSelectToJdbcInsertSelectConverter(sessionFactory);
        walker.visitInsertSelectStatement(sqlAst);
        return new JdbcInsertSelect(){

            @Override
            public String getSql() {
                return walker.getSql();
            }

            @Override
            public List<JdbcParameterBinder> getParameterBinders() {
                return walker.getParameterBinders();
            }

            @Override
            public Set<String> getAffectedTableNames() {
                return walker.getAffectedTableNames();
            }
        };
    }

    private SqlInsertSelectToJdbcInsertSelectConverter(SessionFactoryImplementor sessionFactory) {
        super(sessionFactory);
    }

    private void visitInsertSelectStatement(InsertSelectStatement sqlAst) {
        this.appendSql("insert into ");
        this.appendSql(sqlAst.getTargetTable().getTable().render(this.getSessionFactory().getDialect(), this.getSessionFactory().getJdbcServices().getJdbcEnvironment()));
        this.appendSql(" ");
        this.visitQuerySpec(sqlAst.getSourceSelectStatement());
    }

    @Override
    public void visitAssignment(Assignment assignment) {
        throw new SyntaxException("Encountered assignment clause as part of INSERT-SELECT statement");
    }
}

