/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.consume.spi;

import java.util.List;
import java.util.Set;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.metamodel.model.relational.spi.PhysicalTable;
import org.hibernate.sql.ast.consume.spi.AbstractSqlAstToJdbcOperationConverter;
import org.hibernate.sql.ast.consume.spi.SqlMutationToJdbcMutationConverter;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;
import org.hibernate.sql.exec.spi.JdbcUpdate;

public class UpdateToJdbcUpdateConverter
extends AbstractSqlAstToJdbcOperationConverter
implements SqlMutationToJdbcMutationConverter {
    public static JdbcUpdate createJdbcUpdate(UpdateStatement sqlAst, SessionFactoryImplementor sessionFactory) {
        final UpdateToJdbcUpdateConverter walker = new UpdateToJdbcUpdateConverter(sessionFactory);
        walker.processUpdateStatement(sqlAst);
        return new JdbcUpdate(){

            @Override
            public String getSql() {
                return walker.getSql();
            }

            @Override
            public List<JdbcParameterBinder> getParameterBinders() {
                return walker.getParameterBinders();
            }

            @Override
            public Set<String> getAffectedTableNames() {
                return walker.getAffectedTableNames();
            }
        };
    }

    public UpdateToJdbcUpdateConverter(SessionFactoryImplementor sessionFactory) {
        super(sessionFactory);
    }

    private void processUpdateStatement(UpdateStatement updateStatement) {
        this.appendSql("update ");
        PhysicalTable targetTable = (PhysicalTable)updateStatement.getTargetTable().getTable();
        String tableName = this.getSessionFactory().getJdbcServices().getJdbcEnvironment().getQualifiedObjectNameFormatter().format(targetTable.getQualifiedTableName(), this.getSessionFactory().getJdbcServices().getJdbcEnvironment().getDialect());
        this.appendSql(tableName);
        boolean firstPass = true;
        for (Assignment assignment : updateStatement.getAssignments()) {
            if (firstPass) {
                this.appendSql(" set ");
                firstPass = false;
            } else {
                this.appendSql(", ");
            }
            this.visitAssignment(assignment);
        }
        if (updateStatement.getRestriction() != null) {
            this.appendSql(" where ");
            updateStatement.getRestriction().accept(this);
        }
    }

    @Override
    public void visitAssignment(Assignment assignment) {
        assignment.getColumnReference().accept(this);
        this.appendSql(" = ");
        assignment.getAssignedValue().accept(this);
    }
}

