/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.produce.internal;

import java.util.Collections;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.produce.ConversionException;
import org.hibernate.sql.ast.produce.spi.ColumnReferenceQualifier;
import org.hibernate.sql.ast.produce.spi.NonQualifiableSqlExpressable;
import org.hibernate.sql.ast.produce.spi.QualifiableSqlExpressable;
import org.hibernate.sql.ast.produce.spi.SqlAstCreationState;
import org.hibernate.sql.ast.produce.spi.SqlAstProcessingState;
import org.hibernate.sql.ast.produce.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.produce.spi.SqlSelectionExpression;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.results.spi.SqlSelection;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class SqlAstProcessingStateImpl
implements SqlAstProcessingState,
SqlExpressionResolver {
    private final SqlAstProcessingState parentState;
    private final SqlAstCreationState creationState;
    private final Supplier<Clause> currentClauseAccess;
    private final Supplier<Consumer<Expression>> resolvedExpressionConsumerAccess;

    public SqlAstProcessingStateImpl(SqlAstProcessingState parentState, SqlAstCreationState creationState, Supplier<Clause> currentClauseAccess, Supplier<Consumer<Expression>> resolvedExpressionConsumerAccess) {
        this.parentState = parentState;
        this.creationState = creationState;
        this.currentClauseAccess = currentClauseAccess;
        this.resolvedExpressionConsumerAccess = resolvedExpressionConsumerAccess;
    }

    @Override
    public SqlAstProcessingState getParentState() {
        return this.parentState;
    }

    @Override
    public SqlExpressionResolver getSqlExpressionResolver() {
        return this;
    }

    @Override
    public SqlAstCreationState getSqlAstCreationState() {
        return this.creationState;
    }

    protected Map<Expression, SqlSelection> sqlSelectionMap() {
        return Collections.emptyMap();
    }

    @Override
    public Expression resolveSqlExpression(ColumnReferenceQualifier qualifier, QualifiableSqlExpressable sqlSelectable) {
        Expression expression = this.normalize(qualifier.qualify(sqlSelectable));
        Consumer<Expression> expressionConsumer = this.resolvedExpressionConsumerAccess.get();
        if (expressionConsumer != null) {
            expressionConsumer.accept(expression);
        }
        return expression;
    }

    protected Expression normalize(Expression expression) {
        SqlSelection selection;
        Clause currentClause = this.currentClauseAccess.get();
        if ((currentClause == Clause.ORDER || currentClause == Clause.GROUP || currentClause == Clause.HAVING) && (selection = this.sqlSelectionMap().get(expression)) != null) {
            return new SqlSelectionExpression(selection, expression);
        }
        return expression;
    }

    @Override
    public Expression resolveSqlExpression(NonQualifiableSqlExpressable sqlSelectable) {
        Expression expression = this.normalize(sqlSelectable.createExpression());
        Consumer<Expression> expressionConsumer = this.resolvedExpressionConsumerAccess.get();
        if (expressionConsumer != null) {
            expressionConsumer.accept(expression);
        }
        return expression;
    }

    @Override
    public SqlSelection resolveSqlSelection(Expression expression, BasicJavaDescriptor javaTypeDescriptor, TypeConfiguration typeConfiguration) {
        throw new ConversionException("Unexpected call to resolve SqlSelection outside of QuerySpec processing");
    }

    @Override
    public SqlSelection emptySqlSelection() {
        throw new ConversionException("Unexpected call to resolve SqlSelection outside of QuerySpec processing");
    }
}

