/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.produce.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.consume.spi.SqlAstWalker;
import org.hibernate.sql.ast.produce.internal.SqlAstProcessingStateImpl;
import org.hibernate.sql.ast.produce.spi.SqlAstCreationState;
import org.hibernate.sql.ast.produce.spi.SqlAstProcessingState;
import org.hibernate.sql.ast.produce.spi.SqlAstQuerySpecProcessingState;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.results.internal.EmptySqlSelection;
import org.hibernate.sql.results.spi.SqlSelection;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class SqlAstQuerySpecProcessingStateImpl
extends SqlAstProcessingStateImpl
implements SqlAstQuerySpecProcessingState {
    private final QuerySpec querySpec;
    private final Supplier<Consumer<SqlSelection>> sqlSelectionConsumerSupplier;
    private Map<Expression, SqlSelection> sqlSelectionMap;
    private int nonEmptySelections = 0;

    public SqlAstQuerySpecProcessingStateImpl(QuerySpec querySpec, SqlAstProcessingState parent, SqlAstCreationState creationState, Supplier<Clause> currentClauseAccess, Supplier<Consumer<Expression>> resolvedExpressionConsumerAccess, Supplier<Consumer<SqlSelection>> sqlSelectionConsumerSupplier) {
        super(parent, creationState, currentClauseAccess, resolvedExpressionConsumerAccess);
        this.querySpec = querySpec;
        this.sqlSelectionConsumerSupplier = sqlSelectionConsumerSupplier;
    }

    @Override
    public QuerySpec getInflightQuerySpec() {
        return this.querySpec;
    }

    @Override
    protected Map<Expression, SqlSelection> sqlSelectionMap() {
        return this.sqlSelectionMap;
    }

    @Override
    public SqlSelection resolveSqlSelection(Expression expression, BasicJavaDescriptor javaTypeDescriptor, TypeConfiguration typeConfiguration) {
        SqlSelection existing;
        if (this.sqlSelectionMap == null) {
            this.sqlSelectionMap = new HashMap<Expression, SqlSelection>();
            existing = null;
        } else {
            existing = this.sqlSelectionMap.get(expression);
        }
        if (existing != null) {
            return existing;
        }
        SqlSelection sqlSelection = expression.createSqlSelection(this.nonEmptySelections + 1, this.sqlSelectionMap.size(), javaTypeDescriptor, typeConfiguration);
        this.sqlSelectionMap.put(expression, sqlSelection);
        if (!(sqlSelection instanceof EmptySqlSelection)) {
            ++this.nonEmptySelections;
        }
        this.querySpec.getSelectClause().addSqlSelection(sqlSelection);
        this.sqlSelectionConsumerSupplier.get().accept(sqlSelection);
        return sqlSelection;
    }

    @Override
    public SqlSelection emptySqlSelection() {
        EmptySqlSelection sqlSelection = new EmptySqlSelection(this.sqlSelectionMap.size());
        this.sqlSelectionMap.put(EmptyExpression.EMPTY_EXPRESSION, sqlSelection);
        this.sqlSelectionConsumerSupplier.get().accept(sqlSelection);
        return sqlSelection;
    }

    public static class EmptyExpression
    implements Expression {
        public static final EmptyExpression EMPTY_EXPRESSION = new EmptyExpression();

        private EmptyExpression() {
        }

        @Override
        public SqlSelection createSqlSelection(int jdbcPosition, int valuesArrayPosition, BasicJavaDescriptor javaTypeDescriptor, TypeConfiguration typeConfiguration) {
            return null;
        }

        @Override
        public SqlExpressableType getType() {
            return null;
        }

        public void accept(SqlAstWalker sqlTreeWalker) {
        }
    }
}

