/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.produce.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.consume.spi.SqlAstWalker;
import org.hibernate.sql.ast.produce.spi.ColumnReferenceQualifier;
import org.hibernate.sql.ast.produce.spi.NonQualifiableSqlExpressable;
import org.hibernate.sql.ast.produce.spi.QualifiableSqlExpressable;
import org.hibernate.sql.ast.produce.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.results.internal.EmptySqlSelection;
import org.hibernate.sql.results.spi.SqlSelection;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class StandardSqlExpressionResolver
implements SqlExpressionResolver {
    private final Supplier<QuerySpec> querySpecSupplier;
    private final Function<Expression, Expression> normalizer;
    private final BiConsumer<Expression, SqlSelection> selectionConsumer;
    private Map<Expression, SqlSelection> sqlSelectionMap;
    private int nonEmptySelections = 0;

    public StandardSqlExpressionResolver(Supplier<QuerySpec> querySpecSupplier, Function<Expression, Expression> normalizer, BiConsumer<Expression, SqlSelection> selectionConsumer) {
        this.querySpecSupplier = querySpecSupplier;
        this.normalizer = normalizer;
        this.selectionConsumer = selectionConsumer;
    }

    @Override
    public Expression resolveSqlExpression(ColumnReferenceQualifier qualifier, QualifiableSqlExpressable sqlSelectable) {
        return this.normalizer.apply(qualifier.qualify(sqlSelectable));
    }

    @Override
    public Expression resolveSqlExpression(NonQualifiableSqlExpressable sqlSelectable) {
        return this.normalizer.apply(sqlSelectable.createExpression());
    }

    @Override
    public SqlSelection resolveSqlSelection(Expression expression, BasicJavaDescriptor javaTypeDescriptor, TypeConfiguration typeConfiguration) {
        SqlSelection existing;
        if (this.sqlSelectionMap == null) {
            this.sqlSelectionMap = new HashMap<Expression, SqlSelection>();
            existing = null;
        } else {
            existing = this.sqlSelectionMap.get(expression);
        }
        if (existing != null) {
            return existing;
        }
        SqlSelection sqlSelection = expression.createSqlSelection(this.nonEmptySelections + 1, this.sqlSelectionMap.size(), javaTypeDescriptor, typeConfiguration);
        this.sqlSelectionMap.put(expression, sqlSelection);
        this.selectionConsumer.accept(expression, sqlSelection);
        if (!(sqlSelection instanceof EmptySqlSelection)) {
            ++this.nonEmptySelections;
        }
        QuerySpec querySpec = this.querySpecSupplier.get();
        querySpec.getSelectClause().addSqlSelection(sqlSelection);
        return sqlSelection;
    }

    @Override
    public SqlSelection emptySqlSelection() {
        EmptySqlSelection selection = new EmptySqlSelection(this.sqlSelectionMap.size());
        this.sqlSelectionMap.put(EmptyExpression.EMPTY_EXPRESSION, selection);
        QuerySpec querySpec = this.querySpecSupplier.get();
        querySpec.getSelectClause().addSqlSelection(selection);
        return selection;
    }

    public static class EmptyExpression
    implements Expression {
        public static final EmptyExpression EMPTY_EXPRESSION = new EmptyExpression();

        private EmptyExpression() {
        }

        @Override
        public SqlSelection createSqlSelection(int jdbcPosition, int valuesArrayPosition, BasicJavaDescriptor javaTypeDescriptor, TypeConfiguration typeConfiguration) {
            return null;
        }

        public void accept(SqlAstWalker sqlTreeWalker) {
        }

        @Override
        public SqlExpressableType getType() {
            return null;
        }
    }
}

