/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.produce.metamodel.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.Stack;
import org.hibernate.internal.util.collections.StandardStack;
import org.hibernate.metamodel.model.domain.spi.Navigable;
import org.hibernate.metamodel.model.domain.spi.NavigableContainer;
import org.hibernate.metamodel.model.domain.spi.PluralValuedNavigable;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.spi.ComparisonOperator;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.JoinType;
import org.hibernate.sql.ast.produce.internal.SqlAstQuerySpecProcessingStateImpl;
import org.hibernate.sql.ast.produce.internal.SqlAstSelectDescriptorImpl;
import org.hibernate.sql.ast.produce.metamodel.spi.Fetchable;
import org.hibernate.sql.ast.produce.metamodel.spi.Joinable;
import org.hibernate.sql.ast.produce.metamodel.spi.SqlAliasBaseGenerator;
import org.hibernate.sql.ast.produce.spi.FromClauseAccess;
import org.hibernate.sql.ast.produce.spi.RootTableGroupProducer;
import org.hibernate.sql.ast.produce.spi.SqlAliasBaseManager;
import org.hibernate.sql.ast.produce.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.produce.spi.SqlAstCreationState;
import org.hibernate.sql.ast.produce.spi.SqlAstProcessingState;
import org.hibernate.sql.ast.produce.spi.SqlAstSelectDescriptor;
import org.hibernate.sql.ast.produce.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.produce.spi.SqlQueryOptions;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.predicate.ComparisonPredicate;
import org.hibernate.sql.ast.tree.predicate.InListPredicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.StandardJdbcParameterImpl;
import org.hibernate.sql.results.spi.CircularFetchDetector;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.sql.results.spi.Fetch;
import org.hibernate.sql.results.spi.FetchParent;
import org.hibernate.sql.results.spi.SimpleFromClauseAccessImpl;
import org.jboss.logging.Logger;

public class MetamodelSelectBuilderProcess
implements SqlAstCreationState,
DomainResultCreationState,
SqlQueryOptions {
    private static final Logger log = Logger.getLogger(MetamodelSelectBuilderProcess.class);
    private final SqlAstCreationContext creationContext;
    private final NavigableContainer rootNavigableContainer;
    private final List<Navigable<?>> navigablesToSelect;
    private final Navigable restrictedNavigable;
    private final DomainResult domainResult;
    private final int numberOfKeysToLoad;
    private final LoadQueryInfluencers loadQueryInfluencers;
    private final LockOptions lockOptions;
    private final Stack<SqlAstProcessingState> processingStateStack = new StandardStack<SqlAstProcessingState>();
    private final Set<String> affectedTables = new HashSet<String>();
    private final QuerySpec rootQuerySpec = new QuerySpec(true);
    private final SqlAliasBaseManager sqlAliasBaseManager = new SqlAliasBaseManager();
    private final FromClauseAccess fromClauseAccess = new SimpleFromClauseAccessImpl();
    private final CircularFetchDetector circularFetchDetector = new CircularFetchDetector();
    private int fetchDepth = 0;

    public static SqlAstSelectDescriptor createSelect(SessionFactoryImplementor sessionFactory, NavigableContainer rootNavigableContainer, List<Navigable<?>> navigablesToSelect, Navigable restrictedNavigable, DomainResult domainResult, int numberOfKeysToLoad, LoadQueryInfluencers loadQueryInfluencers, LockOptions lockOptions) {
        MetamodelSelectBuilderProcess process = new MetamodelSelectBuilderProcess(sessionFactory, rootNavigableContainer, navigablesToSelect, restrictedNavigable, domainResult, numberOfKeysToLoad, loadQueryInfluencers, lockOptions);
        return process.execute();
    }

    private MetamodelSelectBuilderProcess(SqlAstCreationContext creationContext, NavigableContainer rootNavigableContainer, List<Navigable<?>> navigablesToSelect, Navigable restrictedNavigable, DomainResult domainResult, int numberOfKeysToLoad, LoadQueryInfluencers loadQueryInfluencers, LockOptions lockOptions) {
        this.creationContext = creationContext;
        this.rootNavigableContainer = rootNavigableContainer;
        this.navigablesToSelect = navigablesToSelect;
        this.restrictedNavigable = restrictedNavigable;
        this.domainResult = domainResult;
        this.numberOfKeysToLoad = numberOfKeysToLoad;
        this.loadQueryInfluencers = loadQueryInfluencers;
        this.lockOptions = lockOptions != null ? lockOptions : LockOptions.NONE;
    }

    @Override
    public SqlAstCreationContext getCreationContext() {
        return this.creationContext;
    }

    @Override
    public SqlAstProcessingState getCurrentProcessingState() {
        return this.processingStateStack.getCurrent();
    }

    private SqlAstSelectDescriptor execute() {
        Expression keyParameterExpression;
        Expression keyColumnExpression;
        List<Object> domainResults;
        this.processingStateStack.push(new SqlAstQuerySpecProcessingStateImpl(this.rootQuerySpec, null, this, () -> null, () -> expression -> {}, () -> sqlSelection -> {}));
        NavigablePath rootNavigablePath = new NavigablePath(this.rootNavigableContainer.getNavigableRole().getFullPath());
        SelectStatement selectStatement = new SelectStatement(this.rootQuerySpec);
        RootTableGroupProducer tableGroupProducer = (RootTableGroupProducer)((Object)this.rootNavigableContainer);
        final TableGroup rootTableGroup = tableGroupProducer.createRootTableGroup(rootNavigablePath, "this", JoinType.INNER, this.lockOptions.getLockMode(), this);
        this.getFromClauseAccess().registerTableGroup(rootNavigablePath, rootTableGroup);
        this.rootQuerySpec.getFromClause().addRoot(rootTableGroup);
        if (this.navigablesToSelect != null && !this.navigablesToSelect.isEmpty()) {
            domainResults = new ArrayList();
            for (Navigable<?> navigable : this.navigablesToSelect) {
                NavigablePath navigablePath = rootNavigablePath.append(navigable.getNavigableName());
                domainResults.add(navigable.createDomainResult(navigablePath, null, this));
            }
        } else {
            DomainResult domainResult = this.domainResult != null ? this.domainResult : this.rootNavigableContainer.createDomainResult(rootNavigablePath, null, this);
            domainResults = Collections.singletonList(domainResult);
        }
        final ArrayList keyColumnReferences = new ArrayList();
        final ArrayList keyParameterReferences = new ArrayList();
        this.restrictedNavigable.visitColumns(new BiConsumer<SqlExpressableType, Column>(){

            @Override
            public void accept(SqlExpressableType type, Column column) {
                keyColumnReferences.add((ColumnReference)MetamodelSelectBuilderProcess.this.getCurrentProcessingState().getSqlExpressionResolver().resolveSqlExpression(rootTableGroup, column));
                keyParameterReferences.add(new StandardJdbcParameterImpl(keyParameterReferences.size(), type, Clause.WHERE, MetamodelSelectBuilderProcess.this.getCreationContext().getDomainModel().getTypeConfiguration()));
            }
        }, Clause.WHERE, this.getCreationContext().getDomainModel().getTypeConfiguration());
        if (keyColumnReferences.size() == 1) {
            keyColumnExpression = (Expression)keyColumnReferences.get(0);
            keyParameterExpression = (Expression)keyParameterReferences.get(0);
        } else {
            keyColumnExpression = new SqlTuple(keyColumnReferences, this.restrictedNavigable);
            keyParameterExpression = new SqlTuple(keyParameterReferences, this.restrictedNavigable);
        }
        if (this.numberOfKeysToLoad <= 1) {
            this.rootQuerySpec.addRestriction(new ComparisonPredicate(keyColumnExpression, ComparisonOperator.EQUAL, keyParameterExpression));
        } else {
            InListPredicate predicate = new InListPredicate(keyColumnExpression);
            for (int i = 0; i < this.numberOfKeysToLoad; ++i) {
                predicate.addExpression(keyParameterExpression);
            }
            this.rootQuerySpec.addRestriction(predicate);
        }
        return new SqlAstSelectDescriptorImpl(selectStatement, domainResults, this.affectedTables);
    }

    @Override
    public SqlAliasBaseGenerator getSqlAliasBaseGenerator() {
        return this.sqlAliasBaseManager;
    }

    @Override
    public SqlAstCreationState getSqlAstCreationState() {
        return this;
    }

    @Override
    public List<Fetch> visitFetches(FetchParent fetchParent) {
        log.tracef("Starting visitation of FetchParent's Fetchables : %s", (Object)fetchParent.getNavigablePath());
        ArrayList<Fetch> fetches = new ArrayList<Fetch>();
        NavigableContainer navigableContainer = fetchParent.getNavigableContainer();
        navigableContainer.visitKeyFetchables(this.getFetchableConsumer(fetchParent, fetches));
        navigableContainer.visitFetchables(this.getFetchableConsumer(fetchParent, fetches));
        return fetches;
    }

    @Override
    public FromClauseAccess getFromClauseAccess() {
        return this.fromClauseAccess;
    }

    private Consumer<Fetchable> getFetchableConsumer(final FetchParent fetchParent, final List<Fetch> fetches) {
        return new Consumer<Fetchable>(){
            private Set<Joinable> processedFetchables;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void accept(Fetchable fetchable) {
                Integer maximumFetchDepth;
                String collectionMappedByProperty;
                boolean joined;
                Fetch biDirectionalFetch;
                boolean isJoinable = fetchable instanceof Joinable;
                if (isJoinable) {
                    boolean alreadySeen;
                    if (this.processedFetchables == null) {
                        this.processedFetchables = new HashSet<Joinable>();
                    }
                    if (!(alreadySeen = this.processedFetchables.add((Joinable)((Object)fetchable)))) {
                        return;
                    }
                }
                if ((biDirectionalFetch = MetamodelSelectBuilderProcess.this.circularFetchDetector.findBiDirectionalFetch(fetchParent, fetchable)) != null) {
                    fetches.add(biDirectionalFetch);
                    return;
                }
                LockMode lockMode = LockMode.READ;
                FetchTiming fetchTiming = fetchable.getMappedFetchStrategy().getTiming();
                boolean bl = joined = fetchable.getMappedFetchStrategy().getStyle() == FetchStyle.JOIN;
                if (MetamodelSelectBuilderProcess.this.rootNavigableContainer instanceof PluralValuedNavigable && (collectionMappedByProperty = ((PluralValuedNavigable)MetamodelSelectBuilderProcess.this.rootNavigableContainer).getCollectionDescriptor().getMappedByProperty()) != null && collectionMappedByProperty.equals(fetchable.getNavigableName())) {
                    joined = false;
                }
                if ((maximumFetchDepth = MetamodelSelectBuilderProcess.this.getCreationContext().getMaximumFetchDepth()) != null) {
                    if (MetamodelSelectBuilderProcess.this.fetchDepth == maximumFetchDepth) {
                        joined = false;
                    } else if (MetamodelSelectBuilderProcess.this.fetchDepth > maximumFetchDepth) {
                        return;
                    }
                }
                try {
                    MetamodelSelectBuilderProcess.this.fetchDepth++;
                    Fetch fetch = fetchable.generateFetch(fetchParent, fetchTiming, joined, lockMode, null, MetamodelSelectBuilderProcess.this);
                    fetches.add(fetch);
                }
                finally {
                    MetamodelSelectBuilderProcess.this.fetchDepth--;
                }
            }
        };
    }

    @Override
    public LockMode determineLockMode(String identificationVariable) {
        return identificationVariable == null ? this.getLockOptions().getLockMode() : this.getLockOptions().getEffectiveLockMode(identificationVariable);
    }

    @Override
    public Integer getFirstRow() {
        return null;
    }

    @Override
    public Integer getMaxRows() {
        return null;
    }

    @Override
    public String getComment() {
        return null;
    }

    @Override
    public List<String> getDatabaseHints() {
        return null;
    }

    @Override
    public LockOptions getLockOptions() {
        return this.lockOptions;
    }

    @Override
    public SqlExpressionResolver getSqlExpressionResolver() {
        return this.getCurrentProcessingState().getSqlExpressionResolver();
    }

    @Override
    public boolean fetchAllAttributes() {
        return false;
    }
}

