/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.produce.metamodel.spi;

import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.hibernate.HibernateException;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.metamodel.model.relational.spi.Table;
import org.hibernate.sql.ast.produce.spi.ColumnReferenceQualifier;
import org.hibernate.sql.ast.produce.spi.QualifiableSqlExpressable;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;

public abstract class AbstractColumnReferenceQualifier
implements ColumnReferenceQualifier {
    private final SortedMap<Column, ColumnReference> columnBindingMap = new TreeMap<Column, ColumnReference>((column1, column2) -> {
        int tableSort = column1.getSourceTable().getTableExpression().compareTo(column2.getSourceTable().getTableExpression());
        if (tableSort != 0) {
            return tableSort;
        }
        return column1.getExpression().compareTo(column2.getExpression());
    });

    protected abstract TableReference getPrimaryTableReference();

    protected abstract List<TableReferenceJoin> getTableReferenceJoins();

    @Override
    public TableReference locateTableReference(Table table) {
        if (table == this.getPrimaryTableReference().getTable()) {
            return this.getPrimaryTableReference();
        }
        for (TableReferenceJoin tableJoin : this.getTableReferenceJoins()) {
            if (tableJoin.getJoinedTableReference().getTable() != table) continue;
            return tableJoin.getJoinedTableReference();
        }
        throw new IllegalStateException("Could not resolve binding for table : " + table);
    }

    @Override
    public ColumnReference resolveColumnReference(Column column) {
        ColumnReference existing = (ColumnReference)this.columnBindingMap.get(column);
        if (existing != null) {
            return existing;
        }
        TableReference tableBinding = this.locateTableReference(column.getSourceTable());
        if (tableBinding == null) {
            throw new HibernateException("Problem resolving Column(" + column.toLoggableString() + ") to ColumnBinding via TableGroup [" + this.loggableString() + "]");
        }
        ColumnReference columnBinding = new ColumnReference(tableBinding, column);
        this.columnBindingMap.put(column, columnBinding);
        return columnBinding;
    }

    @Override
    public ColumnReference resolveColumnReference(String columnName) {
        Column column = this.resolveColumn(columnName);
        return this.resolveColumnReference(column);
    }

    private String loggableString() {
        return "primary table = ` " + this.getPrimaryTableReference().getTable() + '`';
    }

    @Override
    public ColumnReference qualify(QualifiableSqlExpressable sqlSelectable) {
        assert (sqlSelectable instanceof Column);
        return this.resolveColumnReference((Column)sqlSelectable);
    }
}

