/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.produce.ordering.internal;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.internal.CoreLogging;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.metamodel.model.relational.spi.PhysicalColumn;
import org.hibernate.sql.ast.consume.SyntaxException;
import org.hibernate.sql.ast.consume.spi.AbstractSqlAstWalker;
import org.hibernate.sql.ast.produce.ordering.internal.OrderByTranslation;
import org.hibernate.sql.ast.produce.ordering.internal.OrderByTranslationImpl;
import org.hibernate.sql.ast.produce.ordering.internal.TranslationContext;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.sort.SortSpecification;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.jboss.logging.Logger;

public class OrderByFragmentRenderer
extends AbstractSqlAstWalker {
    private static final Logger LOG = CoreLogging.logger(OrderByFragmentRenderer.class);
    private final TranslationContext context;
    private final PersistentCollectionDescriptor collectionDescriptor;
    private List<PhysicalColumn> referencedColumns;

    public static OrderByTranslation renderOrderByFragment(TranslationContext translationContext, PersistentCollectionDescriptor collectionDescriptor, List<SortSpecification> sortSpecifications) {
        OrderByFragmentRenderer renderer = new OrderByFragmentRenderer(translationContext, collectionDescriptor);
        for (SortSpecification sortSpecification : sortSpecifications) {
            renderer.visitSortSpecification(sortSpecification);
        }
        return new OrderByTranslationImpl(renderer.getSql(), renderer.referencedColumns);
    }

    public OrderByFragmentRenderer(TranslationContext context, PersistentCollectionDescriptor collectionDescriptor) {
        super(context.getSessionFactory());
        this.context = context;
        this.collectionDescriptor = collectionDescriptor;
    }

    @Override
    public void visitColumnReference(ColumnReference columnReference) {
        String sqlFragment;
        Column column = columnReference.getColumn();
        if (!PhysicalColumn.class.isInstance(column)) {
            LOG.debugf("@OrderBy fragment referred to formula [%s]; passing through", (Object)column.getExpression());
            sqlFragment = column.getExpression();
        } else {
            PhysicalColumn physicalColumn = (PhysicalColumn)column;
            if (this.referencedColumns == null) {
                this.referencedColumns = new ArrayList<PhysicalColumn>();
            }
            this.referencedColumns.add(physicalColumn);
            sqlFragment = OrderByTranslationImpl.determinePlaceholderText(physicalColumn);
        }
        this.appendSql(sqlFragment);
    }

    @Override
    public void visitAssignment(Assignment assignment) {
        throw new SyntaxException("Encountered unexpected assignment clause");
    }
}

