/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.produce.ordering.internal;

import java.util.List;
import org.hibernate.LockOptions;
import org.hibernate.metamodel.model.domain.spi.PersistentCollectionDescriptor;
import org.hibernate.query.hql.internal.HqlParseTreeBuilder;
import org.hibernate.query.hql.internal.HqlParseTreePrinter;
import org.hibernate.query.hql.internal.HqlParser;
import org.hibernate.query.sqm.tree.select.SqmOrderByClause;
import org.hibernate.sql.ast.produce.ordering.internal.OrderByFragmentConverter;
import org.hibernate.sql.ast.produce.ordering.internal.OrderByFragmentParser;
import org.hibernate.sql.ast.produce.ordering.internal.OrderByFragmentRenderer;
import org.hibernate.sql.ast.produce.ordering.internal.OrderByTranslation;
import org.hibernate.sql.ast.produce.ordering.internal.TranslationContext;
import org.hibernate.sql.ast.produce.spi.SqlQueryOptions;
import org.hibernate.sql.ast.tree.sort.SortSpecification;
import org.jboss.logging.Logger;

public class OrderByFragmentTranslator
implements SqlQueryOptions {
    private static final Logger LOG = Logger.getLogger((String)OrderByFragmentTranslator.class.getName());
    private final TranslationContext translationContext;
    private final PersistentCollectionDescriptor collectionDescriptor;

    public static OrderByTranslation translate(TranslationContext context, PersistentCollectionDescriptor collectionDescriptor, String fragment) {
        return new OrderByFragmentTranslator(context, collectionDescriptor).translateFragment(fragment);
    }

    protected OrderByFragmentTranslator(TranslationContext translationContext, PersistentCollectionDescriptor collectionDescriptor) {
        this.translationContext = translationContext;
        this.collectionDescriptor = collectionDescriptor;
    }

    private OrderByTranslation translateFragment(String fragment) {
        HqlParser parseTree = HqlParseTreeBuilder.INSTANCE.parseHql(fragment);
        HqlParseTreePrinter.logOrderByParseTree(parseTree);
        SqmOrderByClause sqmOrderByClause = OrderByFragmentParser.convertOrderByFragmentParseTree(this.translationContext, this.collectionDescriptor, parseTree.orderByClause());
        List<SortSpecification> sortSpecifications = OrderByFragmentConverter.convertOrderByFragmentSqmTree(this.translationContext.getSessionFactory(), sqmOrderByClause);
        return OrderByFragmentRenderer.renderOrderByFragment(this.translationContext, this.collectionDescriptor, sortSpecifications);
    }

    @Override
    public Integer getFirstRow() {
        return null;
    }

    @Override
    public Integer getMaxRows() {
        return null;
    }

    @Override
    public LockOptions getLockOptions() {
        return LockOptions.NONE;
    }

    @Override
    public String getComment() {
        return null;
    }

    @Override
    public List<String> getDatabaseHints() {
        return null;
    }
}

