/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.produce.ordering.internal;

import java.util.List;
import java.util.Locale;
import org.hibernate.dialect.Dialect;
import org.hibernate.metamodel.model.relational.spi.PhysicalColumn;
import org.hibernate.metamodel.model.relational.spi.PhysicalTable;
import org.hibernate.sql.ast.produce.ordering.internal.OrderByAliasResolver;
import org.hibernate.sql.ast.produce.ordering.internal.OrderByTranslation;

public class OrderByTranslationImpl
implements OrderByTranslation {
    private final String sqlFragmentTemplate;
    private final List<PhysicalColumn> referencedColumns;

    public OrderByTranslationImpl(String sqlFragmentTemplate, List<PhysicalColumn> referencedColumns) {
        this.sqlFragmentTemplate = sqlFragmentTemplate;
        this.referencedColumns = referencedColumns;
    }

    @Override
    public String injectAliases(OrderByAliasResolver aliasResolver) {
        Dialect dialect = aliasResolver.getSessionFactory().getJdbcServices().getJdbcEnvironment().getDialect();
        String sql = this.sqlFragmentTemplate;
        for (PhysicalColumn referencedColumn : this.referencedColumns) {
            String placeholderText;
            String tableAlias = aliasResolver.resolveTableAlias(referencedColumn);
            if (PhysicalTable.class.isInstance(referencedColumn.getSourceTable())) {
                PhysicalTable physicalTable = (PhysicalTable)referencedColumn.getSourceTable();
                placeholderText = OrderByTranslationImpl.determinePhysicalTablePlaceholderText(physicalTable, referencedColumn);
            } else {
                placeholderText = OrderByTranslationImpl.determineVirtualTablePlaceholderText(referencedColumn);
            }
            String renderedColumnName = referencedColumn.getName().render(dialect);
            String replacementText = tableAlias != null ? tableAlias + '.' + renderedColumnName : renderedColumnName;
            sql = sql.replace(placeholderText, replacementText);
        }
        return sql;
    }

    public static String determinePlaceholderText(PhysicalColumn column) {
        if (PhysicalTable.class.isInstance(column.getSourceTable())) {
            return OrderByTranslationImpl.determinePhysicalTablePlaceholderText((PhysicalTable)column.getSourceTable(), column);
        }
        return OrderByTranslationImpl.determineVirtualTablePlaceholderText(column);
    }

    private static String determinePhysicalTablePlaceholderText(PhysicalTable table, PhysicalColumn column) {
        return String.format(Locale.ROOT, "{%s.%s}", table.getTableName().getText(), column.getName().getText());
    }

    private static String determineVirtualTablePlaceholderText(PhysicalColumn column) {
        return '{' + column.getName().getText() + '}';
    }
}

