/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.produce.spi;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.sqm.tree.from.SqmFrom;
import org.hibernate.query.sqm.tree.from.SqmNavigableJoin;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.results.spi.SimpleFromClauseAccessImpl;
import org.jboss.logging.Logger;

public class FromClauseIndex
extends SimpleFromClauseAccessImpl {
    private static final Logger log = Logger.getLogger(FromClauseIndex.class);
    private Map<NavigablePath, TableGroupJoin> tableGroupJoinMap;
    private final Map<String, TableGroup> tableGroupByAliasXref = new HashMap<String, TableGroup>();
    private Map<NavigablePath, SqmNavigableJoin> fetchesByPath;
    private Map<NavigablePath, Map<NavigablePath, SqmNavigableJoin>> fetchesByParentPath;
    private final Set<String> affectedTableNames = new HashSet<String>();

    public Set<String> getAffectedTableNames() {
        return this.affectedTableNames;
    }

    public void register(SqmFrom sqmPath, TableGroup tableGroup) {
        if (sqmPath instanceof SqmNavigableJoin) {
            throw new IllegalArgumentException("Passed SqmPath [" + sqmPath + "] is a SqmNavigableJoin - use the form of #register specific to joins");
        }
        this.performRegistration(sqmPath, tableGroup);
    }

    private void performRegistration(SqmFrom sqmPath, TableGroup tableGroup) {
        TableGroup previousAliasReg;
        this.registerTableGroup(sqmPath.getNavigablePath(), tableGroup);
        if (sqmPath.getExplicitAlias() != null && (previousAliasReg = this.tableGroupByAliasXref.put(sqmPath.getExplicitAlias(), tableGroup)) != null) {
            log.debugf("Encountered previous TableGroup registration [%s] for alias : %s", (Object)previousAliasReg, (Object)sqmPath.getExplicitAlias());
        }
    }

    public boolean isResolved(SqmFrom fromElement) {
        return this.tableGroupMap.containsKey(fromElement.getNavigablePath());
    }

    @Override
    public void registerTableGroup(NavigablePath navigablePath, TableGroup tableGroup) {
        super.registerTableGroup(navigablePath, tableGroup);
        tableGroup.applyAffectedTableNames(this.affectedTableNames::add);
    }

    public void register(SqmNavigableJoin join, TableGroupJoin tableGroupJoin) {
        this.performRegistration(join, tableGroupJoin.getJoinedGroup());
        if (this.tableGroupJoinMap == null) {
            this.tableGroupJoinMap = new HashMap<NavigablePath, TableGroupJoin>();
        }
        this.tableGroupJoinMap.put(join.getNavigablePath(), tableGroupJoin);
        if (join.isFetched()) {
            if (this.fetchesByPath == null) {
                this.fetchesByPath = new HashMap<NavigablePath, SqmNavigableJoin>();
            }
            this.fetchesByPath.put(join.getNavigablePath(), join);
            if (this.fetchesByParentPath == null) {
                this.fetchesByParentPath = new HashMap<NavigablePath, Map<NavigablePath, SqmNavigableJoin>>();
            }
            Map fetchesForParent = this.fetchesByParentPath.computeIfAbsent(join.getNavigablePath().getParent(), navigablePath -> new HashMap());
            fetchesForParent.put(join.getNavigablePath(), join);
        }
    }

    public TableGroupJoin findTableGroupJoin(NavigablePath navigablePath) {
        return this.tableGroupJoinMap == null ? null : this.tableGroupJoinMap.get(navigablePath);
    }

    public SqmNavigableJoin findFetchedJoinByPath(NavigablePath path) {
        return this.fetchesByPath == null ? null : this.fetchesByPath.get(path);
    }
}

