/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.produce.spi;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.sql.ast.produce.metamodel.spi.SqlAliasBaseGenerator;
import org.hibernate.sql.ast.produce.spi.SqlAliasBase;

public class SqlAliasBaseManager
implements SqlAliasBaseGenerator {
    private Map<String, Integer> acronymCountMap = new HashMap<String, Integer>();

    @Override
    public SqlAliasBase createSqlAliasBase(String stem) {
        Integer acronymCount = this.acronymCountMap.get(stem);
        if (acronymCount == null) {
            acronymCount = 0;
        }
        Integer n = acronymCount;
        Integer n2 = acronymCount = Integer.valueOf(acronymCount + 1);
        this.acronymCountMap.put(stem, acronymCount);
        return new SqlAliasBaseImpl(stem + acronymCount);
    }

    private static class SqlAliasBaseImpl
    implements SqlAliasBase {
        private final String stem;
        private int aliasCount;

        SqlAliasBaseImpl(String stem) {
            this.stem = stem;
        }

        @Override
        public String getAliasStem() {
            return this.stem;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String generateNewAlias() {
            SqlAliasBaseImpl sqlAliasBaseImpl = this;
            synchronized (sqlAliasBaseImpl) {
                return this.stem + '_' + this.aliasCount++;
            }
        }
    }
}

