/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.produce.sqm.spi;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.hibernate.HibernateException;
import org.hibernate.LockMode;
import org.hibernate.LockOptions;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.engine.FetchStyle;
import org.hibernate.engine.FetchTiming;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.metamodel.model.domain.spi.NavigableContainer;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.sqm.consume.spi.BaseSqmToSqlAstConverter;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.tree.expression.SqmLiteralEntityType;
import org.hibernate.query.sqm.tree.from.SqmNavigableJoin;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiation;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiationArgument;
import org.hibernate.query.sqm.tree.select.SqmDynamicInstantiationTarget;
import org.hibernate.query.sqm.tree.select.SqmSelectStatement;
import org.hibernate.query.sqm.tree.select.SqmSelection;
import org.hibernate.sql.ast.JoinType;
import org.hibernate.sql.ast.produce.metamodel.spi.Fetchable;
import org.hibernate.sql.ast.produce.metamodel.spi.Joinable;
import org.hibernate.sql.ast.produce.spi.FromClauseAccess;
import org.hibernate.sql.ast.produce.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.produce.spi.SqlAstCreationState;
import org.hibernate.sql.ast.produce.spi.TableGroupJoinProducer;
import org.hibernate.sql.ast.produce.sqm.internal.SqmSelectInterpretationImpl;
import org.hibernate.sql.ast.produce.sqm.spi.Callback;
import org.hibernate.sql.ast.produce.sqm.spi.SqmSelectInterpretation;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.QueryLiteral;
import org.hibernate.sql.ast.tree.expression.domain.EntityTypeLiteral;
import org.hibernate.sql.ast.tree.expression.instantiation.DynamicInstantiation;
import org.hibernate.sql.ast.tree.expression.instantiation.DynamicInstantiationNature;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.results.spi.CircularFetchDetector;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.sql.results.spi.DomainResultProducer;
import org.hibernate.sql.results.spi.Fetch;
import org.hibernate.sql.results.spi.FetchParent;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;

public class SqmSelectToSqlAstConverter
extends BaseSqmToSqlAstConverter
implements DomainResultCreationState {
    private final List<DomainResult> domainResults = new ArrayList<DomainResult>();
    private final CircularFetchDetector circularFetchDetector = new CircularFetchDetector();
    private int fetchDepth = 0;
    private Set<Fetchable> processedFetchables;

    public SqmSelectToSqlAstConverter(QueryOptions queryOptions, DomainParameterXref domainParameterXref, QueryParameterBindings domainParameterBindings, LoadQueryInfluencers influencers, Callback callback, SqlAstCreationContext creationContext) {
        super(creationContext, queryOptions, domainParameterXref, domainParameterBindings, influencers, callback);
    }

    public SqmSelectInterpretation interpret(SqmSelectStatement statement) {
        return new SqmSelectInterpretationImpl(this.visitSelectStatement(statement), this.domainResults, this.getFromClauseIndex().getAffectedTableNames(), this.getJdbcParamsBySqmParam());
    }

    @Override
    public boolean fetchAllAttributes() {
        return false;
    }

    @Override
    public SqlAstCreationState getSqlAstCreationState() {
        return this;
    }

    @Override
    public SelectStatement visitSelectStatement(SqmSelectStatement statement) {
        QuerySpec querySpec = this.visitQuerySpec(statement.getQuerySpec());
        return new SelectStatement(querySpec);
    }

    @Override
    public Void visitSelection(SqmSelection sqmSelection) {
        DomainResultProducer resultProducer = (DomainResultProducer)sqmSelection.getSelectableNode().accept(this);
        if (this.getProcessingStateStack().depth() > 1) {
            resultProducer.applySqlSelections(this);
        } else {
            DomainResult domainResult = resultProducer.createDomainResult(sqmSelection.getAlias(), this);
            this.domainResults.add(domainResult);
        }
        return null;
    }

    private int currentFetchDepth() {
        return this.fetchDepth;
    }

    @Override
    public List<Fetch> visitFetches(FetchParent fetchParent) {
        ArrayList<Fetch> fetches = new ArrayList<Fetch>();
        Consumer<Fetchable> fetchableConsumer = fetchable -> {
            Fetch biDirectionalFetch = this.circularFetchDetector.findBiDirectionalFetch(fetchParent, (Fetchable)fetchable);
            if (biDirectionalFetch != null) {
                fetches.add(biDirectionalFetch);
                return;
            }
            try {
                ++this.fetchDepth;
                Fetch fetch = this.buildFetch(fetchParent, (Fetchable)fetchable);
                if (fetch != null) {
                    fetches.add(fetch);
                }
            }
            finally {
                --this.fetchDepth;
            }
        };
        NavigableContainer navigableContainer = fetchParent.getNavigableContainer();
        navigableContainer.visitKeyFetchables(fetchableConsumer);
        navigableContainer.visitFetchables(fetchableConsumer);
        return fetches;
    }

    private Fetch buildFetch(FetchParent fetchParent, Fetchable fetchable) {
        String alias;
        boolean joined;
        NavigablePath fetchablePath = fetchParent.getNavigablePath().append(fetchable.getNavigableName());
        LockMode lockMode = LockMode.READ;
        FetchTiming fetchTiming = fetchable.getMappedFetchStrategy().getTiming();
        SqmNavigableJoin fetchedJoin = this.getFromClauseIndex().findFetchedJoinByPath(fetchablePath);
        if (fetchedJoin != null) {
            assert (this.getFromClauseIndex().getTableGroup(fetchablePath) != null);
            fetchTiming = FetchTiming.IMMEDIATE;
            joined = true;
            alias = fetchedJoin.getExplicitAlias();
            lockMode = this.determineLockMode(alias);
        } else {
            Integer maxDepth;
            alias = null;
            if (fetchable instanceof Joinable) {
                boolean added;
                if (this.processedFetchables == null) {
                    this.processedFetchables = new HashSet<Fetchable>();
                }
                joined = !(added = this.processedFetchables.add(fetchable)) ? false : fetchTiming == FetchTiming.IMMEDIATE && fetchable.getMappedFetchStrategy().getStyle() == FetchStyle.JOIN;
            } else {
                joined = true;
            }
            TableGroup existingJoinedGroup = this.getFromClauseIndex().findTableGroup(fetchablePath);
            if (existingJoinedGroup != null) {
                // empty if block
            }
            if ((maxDepth = this.getCreationContext().getMaximumFetchDepth()) != null) {
                if (this.fetchDepth == maxDepth) {
                    joined = false;
                } else if (this.fetchDepth > maxDepth) {
                    return null;
                }
            }
            if (joined && fetchable instanceof TableGroupJoinProducer) {
                this.getFromClauseIndex().resolveTableGroup(fetchablePath, np -> {
                    TableGroup lhs = this.getFromClauseIndex().getTableGroup(fetchParent.getNavigablePath());
                    TableGroupJoin tableGroupJoin = ((TableGroupJoinProducer)((Object)fetchable)).createTableGroupJoin(fetchablePath, lhs, null, JoinType.LEFT, LockMode.NONE, this);
                    lhs.addTableGroupJoin(tableGroupJoin);
                    return tableGroupJoin.getJoinedGroup();
                });
            }
        }
        try {
            return fetchable.generateFetch(fetchParent, fetchTiming, joined, lockMode, alias, this);
        }
        catch (RuntimeException e) {
            throw new HibernateException(String.format(Locale.ROOT, "Could not generate fetch : %s -> %s", fetchParent.getNavigablePath(), fetchable.getNavigableName()), e);
        }
    }

    @Override
    public FromClauseAccess getFromClauseAccess() {
        return this.getFromClauseIndex();
    }

    @Override
    public LockMode determineLockMode(String identificationVariable) {
        LockOptions lockOptions = this.getQueryOptions().getLockOptions();
        return lockOptions.getScope() || identificationVariable == null ? lockOptions.getLockMode() : lockOptions.getEffectiveLockMode(identificationVariable);
    }

    @Override
    public DynamicInstantiation visitDynamicInstantiation(SqmDynamicInstantiation sqmDynamicInstantiation) {
        SqmDynamicInstantiationTarget instantiationTarget = sqmDynamicInstantiation.getInstantiationTarget();
        DynamicInstantiationNature instantiationNature = instantiationTarget.getNature();
        JavaTypeDescriptor targetTypeDescriptor = this.interpretInstantiationTarget(instantiationTarget);
        DynamicInstantiation dynamicInstantiation = new DynamicInstantiation(instantiationNature, targetTypeDescriptor);
        for (SqmDynamicInstantiationArgument sqmArgument : sqmDynamicInstantiation.getArguments()) {
            DomainResultProducer argumentResultProducer = (DomainResultProducer)sqmArgument.getSelectableNode().accept(this);
            dynamicInstantiation.addArgument(sqmArgument.getAlias(), argumentResultProducer);
        }
        dynamicInstantiation.complete();
        return dynamicInstantiation;
    }

    private <T> JavaTypeDescriptor<T> interpretInstantiationTarget(SqmDynamicInstantiationTarget instantiationTarget) {
        Class targetJavaType = instantiationTarget.getNature() == DynamicInstantiationNature.LIST ? List.class : (instantiationTarget.getNature() == DynamicInstantiationNature.MAP ? Map.class : instantiationTarget.getJavaType());
        return this.getCreationContext().getDomainModel().getTypeConfiguration().getJavaTypeDescriptorRegistry().getDescriptor(targetJavaType);
    }

    @Override
    public Expression visitEntityTypeLiteralExpression(SqmLiteralEntityType expression) {
        return new EntityTypeLiteral(expression.getExpressableType().getEntityDescriptor());
    }

    @Override
    public Object visitFullyQualifiedClass(Class namedClass) {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public QueryLiteral visitFullyQualifiedEnum(Enum value) {
        return new QueryLiteral(value, this.getTypeConfiguration().standardExpressableTypeForJavaType(value.getClass()).getSqlExpressableType(), this.getCurrentClauseStack().getCurrent());
    }

    @Override
    public QueryLiteral visitFullyQualifiedField(Field field) {
        try {
            Object value = field.get(null);
            return new QueryLiteral(value, this.getTypeConfiguration().standardExpressableTypeForJavaType(value.getClass()).getSqlExpressableType(), this.getCurrentClauseStack().getCurrent());
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException();
        }
    }
}

