/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.produce.sqm.spi;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.loader.spi.AfterLoadAction;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.metamodel.model.domain.spi.EntityValuedNavigable;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.metamodel.model.relational.spi.Table;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.query.spi.QueryParameterBindings;
import org.hibernate.query.sqm.consume.spi.BaseSqmToSqlAstConverter;
import org.hibernate.query.sqm.internal.DomainParameterXref;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.update.SqmAssignment;
import org.hibernate.query.sqm.tree.update.SqmSetClause;
import org.hibernate.query.sqm.tree.update.SqmUpdateStatement;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.JoinType;
import org.hibernate.sql.ast.consume.spi.SqlAppender;
import org.hibernate.sql.ast.consume.spi.SqlAstWalker;
import org.hibernate.sql.ast.produce.ConversionException;
import org.hibernate.sql.ast.produce.SqlTreeException;
import org.hibernate.sql.ast.produce.internal.SqlAstProcessingStateImpl;
import org.hibernate.sql.ast.produce.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.produce.sqm.internal.SqmUpdateInterpretationImpl;
import org.hibernate.sql.ast.produce.sqm.spi.SqmUpdateInterpretation;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.domain.AssignableNavigableReference;
import org.hibernate.sql.ast.tree.expression.domain.NavigableReference;
import org.hibernate.sql.ast.tree.from.AbstractTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;
import org.hibernate.sql.ast.tree.predicate.InSubQueryPredicate;
import org.hibernate.sql.ast.tree.select.QuerySpec;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.ast.tree.update.UpdateStatement;
import org.jboss.logging.Logger;

public class SqmUpdateToSqlAstConverterMultiTable
extends BaseSqmToSqlAstConverter {
    private static final Logger log = Logger.getLogger(SqmUpdateToSqlAstConverterMultiTable.class);
    private final EntityTypeDescriptor<?> entityDescriptor;
    private final TableGroup entityTableGroup;
    private final QuerySpec idTableSelect;
    private AssignmentContext currentAssignmentContext;
    private Map<TableReference, UpdateStatement.UpdateStatementBuilder> updateStatementBuilderMap = new HashMap<TableReference, UpdateStatement.UpdateStatementBuilder>();

    public static SqmUpdateInterpretation interpret(SqmUpdateStatement sqmStatement, QuerySpec idTableSelect, QueryOptions queryOptions, DomainParameterXref domainParameterXref, QueryParameterBindings domainParameterBindings, SqlAstCreationContext creationContext) {
        SqmUpdateToSqlAstConverterMultiTable walker = new SqmUpdateToSqlAstConverterMultiTable(sqmStatement, idTableSelect, queryOptions, domainParameterXref, domainParameterBindings, creationContext);
        walker.visitUpdateStatement(sqmStatement);
        ArrayList<UpdateStatement> updateStatements = new ArrayList<UpdateStatement>();
        HashSet<String> affectedTableNames = new HashSet<String>();
        for (UpdateStatement.UpdateStatementBuilder builder : walker.updateStatementBuilderMap.values()) {
            UpdateStatement sqlAst = builder.createUpdateAst();
            if (sqlAst == null) continue;
            affectedTableNames.add(sqlAst.getTargetTable().getTable().getTableExpression());
            updateStatements.add(sqlAst);
        }
        return new SqmUpdateInterpretationImpl(updateStatements, affectedTableNames, walker.getJdbcParamsBySqmParam());
    }

    private SqmUpdateToSqlAstConverterMultiTable(SqmUpdateStatement sqmStatement, QuerySpec idTableSelect, QueryOptions queryOptions, DomainParameterXref domainParameterXref, QueryParameterBindings domainParameterBindings, SqlAstCreationContext creationContext) {
        super(creationContext, queryOptions, domainParameterXref, domainParameterBindings, LoadQueryInfluencers.NONE, (AfterLoadAction afterLoadAction) -> {});
        this.idTableSelect = idTableSelect;
        SqmRoot deleteTarget = sqmStatement.getTarget();
        this.entityDescriptor = deleteTarget.getReferencedNavigable().getEntityDescriptor();
        this.entityTableGroup = this.entityDescriptor.createRootTableGroup(deleteTarget.getNavigablePath(), deleteTarget.getExplicitAlias(), JoinType.INNER, queryOptions.getLockOptions().getLockMode(), this);
        this.getFromClauseIndex().register(deleteTarget, this.entityTableGroup);
        TableGroupMock tableGroup = new TableGroupMock(this.entityTableGroup);
        tableGroup.applyAffectedTableNames(this.getFromClauseIndex().getAffectedTableNames()::add);
        this.primeStack(this.getTableGroupStack(), tableGroup);
        this.getFromClauseIndex().register(deleteTarget, tableGroup);
        this.getProcessingStateStack().push(new SqlAstProcessingStateImpl(null, this, this.getCurrentClauseStack()::getCurrent, () -> expr -> {}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object visitUpdateStatement(SqmUpdateStatement sqmStatement) {
        this.getCurrentClauseStack().push(Clause.UPDATE);
        try {
            for (SqmAssignment sqmAssignment : sqmStatement.getSetClause().getAssignments()) {
                this.currentAssignmentContext = new AssignmentContext(sqmAssignment);
                AssignableNavigableReference targetReference = (AssignableNavigableReference)sqmAssignment.getTargetPath().accept(this);
                assert (this.currentAssignmentContext.tableReference != null);
                targetReference.applySqlAssignments((Expression)sqmAssignment.getValue().accept(this), this.currentAssignmentContext, this.updateStatementBuilderMap.get(this.currentAssignmentContext.tableReference)::addAssignment, this.getCreationContext());
                this.currentAssignmentContext = null;
            }
        }
        finally {
            this.getCurrentClauseStack().pop();
        }
        return null;
    }

    @Override
    public Object visitSetClause(SqmSetClause setClause) {
        this.getCurrentClauseStack().push(Clause.UPDATE);
        try {
            Object t = super.visitSetClause(setClause);
            return t;
        }
        finally {
            this.getCurrentClauseStack().pop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Assignment visitAssignment(SqmAssignment sqmAssignment) {
        this.currentAssignmentContext = new AssignmentContext(sqmAssignment);
        try {
            NavigableReference stateField = (NavigableReference)sqmAssignment.getTargetPath().accept(this);
            this.currentAssignmentContext.endStateFieldProcessing();
            if (stateField instanceof AssignableNavigableReference) {
                // empty if block
            }
            Expression assignedValue = (Expression)sqmAssignment.getValue().accept(this);
            Assignment assignment = null;
            TableReference assignmentTableReference = this.currentAssignmentContext.tableReference;
            UpdateStatement.UpdateStatementBuilder concreteUpdateStatementBuilder = this.updateStatementBuilderMap.get(assignmentTableReference);
            if (concreteUpdateStatementBuilder == null) {
                concreteUpdateStatementBuilder = new UpdateStatement.UpdateStatementBuilder(assignmentTableReference);
                concreteUpdateStatementBuilder.addRestriction(new InSubQueryPredicate(null, this.idTableSelect, false));
                this.updateStatementBuilderMap.put(assignmentTableReference, concreteUpdateStatementBuilder);
            }
            concreteUpdateStatementBuilder.addAssignment(assignment);
            Assignment assignment2 = assignment;
            return assignment2;
        }
        finally {
            this.currentAssignmentContext = null;
        }
    }

    public class AssignmentContext {
        private final String assignmentText;
        private boolean processingStateField;
        private TableReference tableReference;

        private AssignmentContext(SqmAssignment assignment) {
            this.assignmentText = assignment.getTargetPath().asLoggableText() + " = " + assignment.getValue().asLoggableText();
            log.debugf("Initializing AssignmentContext [%s]", (Object)this.assignmentText);
        }

        private void injectTableReference(TableReference tableReference) {
            if (this.processingStateField) {
                if (tableReference != null && tableReference != this.tableReference) {
                    throw new ConversionException(String.format(Locale.ROOT, "Multiple TableReferences found for assignment [%s]", this.assignmentText));
                }
            } else if (!this.tableReference.equals(tableReference)) {
                throw new SqlTreeException("Assignment as part of multi-table update query referenced multiple tables [" + this.assignmentText + "]");
            }
            this.tableReference = tableReference;
        }

        private void endStateFieldProcessing() {
            if (this.tableReference == null) {
                throw new SqlTreeException("Could not determine backing TableReference for assignment state-field");
            }
            this.processingStateField = false;
        }

        public TableReference resolveTableReference(Table table) {
            return SqmUpdateToSqlAstConverterMultiTable.this.entityTableGroup.locateTableReference(table);
        }
    }

    private class TableGroupMock
    extends AbstractTableGroup {
        private final TableGroup entityTableGroup;

        private TableGroupMock(TableGroup entityTableGroup) {
            super(entityTableGroup.getNavigablePath(), entityTableGroup.getNavigable(), entityTableGroup.getLockMode());
            this.entityTableGroup = entityTableGroup;
        }

        @Override
        public TableReference locateTableReference(Table table) {
            TableReference tableReference = this.entityTableGroup.locateTableReference(table);
            if (SqmUpdateToSqlAstConverterMultiTable.this.currentAssignmentContext != null) {
                SqmUpdateToSqlAstConverterMultiTable.this.currentAssignmentContext.injectTableReference(tableReference);
            }
            return tableReference;
        }

        @Override
        public Column resolveColumn(String columnName) {
            return this.entityTableGroup.resolveColumn(columnName);
        }

        @Override
        public void render(SqlAppender sqlAppender, SqlAstWalker walker) {
        }

        @Override
        public void applyAffectedTableNames(Consumer<String> nameCollector) {
            this.entityTableGroup.applyAffectedTableNames(nameCollector);
        }

        @Override
        public TableReference getPrimaryTableReference() {
            return this.entityTableGroup.locateTableReference(((EntityValuedNavigable)this.entityTableGroup.getNavigable()).getEntityDescriptor().getPrimaryTable());
        }

        @Override
        public List<TableReferenceJoin> getTableReferenceJoins() {
            return null;
        }
    }
}

