/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.expression;

import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.consume.spi.SqlAstWalker;
import org.hibernate.sql.ast.tree.expression.AbstractStandardFunction;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.sql.results.spi.SqlSelection;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class AbsFunction
extends AbstractStandardFunction {
    private final Expression argument;

    public AbsFunction(Expression argument) {
        this.argument = argument;
    }

    @Override
    public SqlExpressableType getExpressableType() {
        return this.argument.getType();
    }

    public Expression getArgument() {
        return this.argument;
    }

    public void accept(SqlAstWalker sqlTreeWalker) {
        sqlTreeWalker.visitAbsFunction(this);
    }

    @Override
    public SqlExpressableType getType() {
        return this.getExpressableType();
    }

    @Override
    public SqlSelection createSqlSelection(int jdbcPosition, int valuesArrayPosition, BasicJavaDescriptor javaTypeDescriptor, TypeConfiguration typeConfiguration) {
        return new SqlSelectionImpl(jdbcPosition, valuesArrayPosition, (Expression)this, this.getType().getSqlTypeDescriptor().getSqlExpressableType(this.getType().getJavaTypeDescriptor(), typeConfiguration));
    }
}

