/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.expression;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.produce.spi.SqlExpressable;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.sql.results.internal.domain.basic.BasicResultImpl;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.sql.results.spi.DomainResultProducer;
import org.hibernate.sql.results.spi.SqlSelection;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public abstract class AbstractLiteral
implements JdbcParameterBinder,
Expression,
SqlExpressable,
DomainResultProducer {
    private final Object value;
    private final SqlExpressableType type;
    private final Clause clause;

    public AbstractLiteral(Object value, SqlExpressableType type, Clause clause) {
        this.value = value;
        this.type = type;
        this.clause = clause;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public SqlExpressableType getExpressableType() {
        return this.type;
    }

    public boolean isInSelect() {
        return this.clause == Clause.SELECT;
    }

    @Override
    public SqlSelection createSqlSelection(int jdbcPosition, int valuesArrayPosition, BasicJavaDescriptor javaTypeDescriptor, TypeConfiguration typeConfiguration) {
        return new SqlSelectionImpl(jdbcPosition, valuesArrayPosition, (Expression)this, this.getType());
    }

    @Override
    public DomainResult createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        return new BasicResultImpl(resultVariable, creationState.getSqlExpressionResolver().resolveSqlSelection(this, this.getType().getJavaTypeDescriptor(), creationState.getSqlAstCreationState().getCreationContext().getDomainModel().getTypeConfiguration()), this.getType());
    }

    @Override
    public int bindParameterValue(PreparedStatement statement, int startPosition, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) throws SQLException {
        this.getType().getJdbcValueBinder().bind(statement, startPosition, this.value, executionContext);
        return 1;
    }

    @Override
    public SqlExpressableType getType() {
        return this.type;
    }
}

