/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.expression;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.sql.JdbcValueBinder;
import org.hibernate.sql.JdbcValueExtractor;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.produce.metamodel.spi.BasicValuedExpressableType;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.GenericParameter;
import org.hibernate.sql.exec.ExecutionException;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameter;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;
import org.hibernate.sql.exec.spi.JdbcParameterBinding;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.sql.results.internal.domain.basic.BasicResultImpl;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.sql.results.spi.DomainResultProducer;
import org.hibernate.sql.results.spi.SqlSelection;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.descriptor.sql.spi.StandardSqlExpressableTypeImpl;
import org.hibernate.type.spi.BasicType;
import org.hibernate.type.spi.TypeConfiguration;

public abstract class AbstractParameter
implements GenericParameter,
JdbcParameter,
JdbcParameterBinder,
DomainResultProducer {
    private final SqlExpressableType type;
    private final Clause clause;
    private final TypeConfiguration typeConfiguration;

    public AbstractParameter(SqlExpressableType type, Clause clause, TypeConfiguration typeConfiguration) {
        this.type = type;
        this.clause = clause;
        this.typeConfiguration = typeConfiguration;
    }

    @Override
    public SqlExpressableType getExpressableType() {
        return this.type;
    }

    @Override
    public JdbcParameterBinder getParameterBinder() {
        return this;
    }

    @Override
    public int bindParameterValue(PreparedStatement statement, int startPosition, JdbcParameterBindings jdbcParamBindings, ExecutionContext executionContext) throws SQLException {
        JdbcParameterBinding binding = jdbcParamBindings.getBinding(this);
        if (binding == null) {
            throw new ExecutionException("JDBC parameter value not bound - " + this);
        }
        SqlExpressableType bindType = binding.getBindType();
        if (bindType == null) {
            bindType = this.guessBindType(executionContext, binding);
        }
        Object bindValue = binding.getBindValue();
        bindType.getJdbcValueBinder().bind(statement, startPosition, bindValue, executionContext);
        return 1;
    }

    private SqlExpressableType guessBindType(ExecutionContext executionContext, JdbcParameterBinding binding) {
        BasicType<?> basicType = executionContext.getSession().getFactory().getTypeConfiguration().getBasicTypeRegistry().getBasicType(binding.getBindValue().getClass());
        JdbcValueBinder binder = basicType.getSqlExpressableType(this.typeConfiguration).getJdbcValueBinder();
        JdbcValueExtractor extractor = basicType.getSqlExpressableType(this.typeConfiguration).getJdbcValueExtractor();
        return new StandardSqlExpressableTypeImpl((BasicJavaDescriptor)basicType.getJavaTypeDescriptor(), basicType.getSqlTypeDescriptor(), extractor, binder);
    }

    @Override
    public DomainResult createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        return new BasicResultImpl(resultVariable, creationState.getSqlExpressionResolver().resolveSqlSelection(this, this.type.getJavaTypeDescriptor(), creationState.getSqlAstCreationState().getCreationContext().getDomainModel().getTypeConfiguration()), this.getExpressableType());
    }

    @Override
    public SqlSelection createSqlSelection(int jdbcPosition, int valuesArrayPosition, BasicJavaDescriptor javaTypeDescriptor, TypeConfiguration typeConfiguration) {
        return new SqlSelectionImpl(jdbcPosition, valuesArrayPosition, (Expression)this, ((BasicValuedExpressableType)((Object)this.getType())).getSqlExpressableType());
    }

    @Override
    public SqlExpressableType getType() {
        return this.type;
    }
}

