/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.expression;

import org.hibernate.query.BinaryArithmeticOperator;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.consume.spi.SqlAstWalker;
import org.hibernate.sql.ast.produce.spi.SqlExpressable;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.sql.results.internal.domain.basic.BasicResultImpl;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.sql.results.spi.DomainResultProducer;
import org.hibernate.sql.results.spi.SqlSelection;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class BinaryArithmeticExpression
implements Expression,
SqlExpressable,
DomainResultProducer {
    private final Expression lhsOperand;
    private final BinaryArithmeticOperator operator;
    private final Expression rhsOperand;
    private final SqlExpressableType resultType;

    public BinaryArithmeticExpression(Expression lhsOperand, BinaryArithmeticOperator operator, Expression rhsOperand, SqlExpressableType resultType) {
        this.operator = operator;
        this.lhsOperand = lhsOperand;
        this.rhsOperand = rhsOperand;
        this.resultType = resultType;
    }

    @Override
    public SqlExpressableType getExpressableType() {
        return this.resultType;
    }

    @Override
    public SqlExpressableType getType() {
        return this.resultType;
    }

    @Override
    public SqlSelection createSqlSelection(int jdbcPosition, int valuesArrayPosition, BasicJavaDescriptor javaTypeDescriptor, TypeConfiguration typeConfiguration) {
        return new SqlSelectionImpl(jdbcPosition, valuesArrayPosition, (Expression)this, this.getExpressableType());
    }

    public void accept(SqlAstWalker walker) {
        walker.visitBinaryArithmeticExpression(this);
    }

    @Override
    public DomainResult createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        return new BasicResultImpl(resultVariable, creationState.getSqlExpressionResolver().resolveSqlSelection(this, this.getType().getJavaTypeDescriptor(), creationState.getSqlAstCreationState().getCreationContext().getDomainModel().getTypeConfiguration()), this.resultType);
    }

    public Expression getLeftHandOperand() {
        return this.lhsOperand;
    }

    public BinaryArithmeticOperator getOperator() {
        return this.operator;
    }

    public Expression getRightHandOperand() {
        return this.rhsOperand;
    }
}

