/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.expression;

import java.util.ArrayList;
import java.util.List;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.consume.spi.SqlAstWalker;
import org.hibernate.sql.ast.produce.spi.SqlExpressable;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.sql.results.internal.domain.basic.BasicResultImpl;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.sql.results.spi.DomainResultProducer;
import org.hibernate.sql.results.spi.Selectable;
import org.hibernate.sql.results.spi.SqlSelection;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class CaseSimpleExpression
implements Expression,
Selectable,
SqlExpressable,
DomainResultProducer {
    private final SqlExpressableType type;
    private final Expression fixture;
    private List<WhenFragment> whenFragments = new ArrayList<WhenFragment>();
    private Expression otherwise;

    public CaseSimpleExpression(SqlExpressableType type, Expression fixture) {
        this.type = type;
        this.fixture = fixture;
    }

    public Expression getFixture() {
        return this.fixture;
    }

    @Override
    public SqlExpressableType getExpressableType() {
        return this.type;
    }

    @Override
    public SqlExpressableType getType() {
        return this.type;
    }

    @Override
    public SqlSelection createSqlSelection(int jdbcPosition, int valuesArrayPosition, BasicJavaDescriptor javaTypeDescriptor, TypeConfiguration typeConfiguration) {
        return new SqlSelectionImpl(jdbcPosition, valuesArrayPosition, (Expression)this, this.getExpressableType());
    }

    public void accept(SqlAstWalker walker) {
        walker.visitCaseSimpleExpression(this);
    }

    @Override
    public DomainResult createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        return new BasicResultImpl(resultVariable, creationState.getSqlExpressionResolver().resolveSqlSelection(this, this.getType().getJavaTypeDescriptor(), creationState.getSqlAstCreationState().getCreationContext().getDomainModel().getTypeConfiguration()), this.getType());
    }

    public List<WhenFragment> getWhenFragments() {
        return this.whenFragments;
    }

    public Expression getOtherwise() {
        return this.otherwise;
    }

    public void otherwise(Expression otherwiseExpression) {
        this.otherwise = otherwiseExpression;
    }

    public void when(Expression test, Expression result) {
        this.whenFragments.add(new WhenFragment(test, result));
    }

    public static class WhenFragment {
        private final Expression checkValue;
        private final Expression result;

        public WhenFragment(Expression checkValue, Expression result) {
            this.checkValue = checkValue;
            this.result = result;
        }

        public Expression getCheckValue() {
            return this.checkValue;
        }

        public Expression getResult() {
            return this.result;
        }
    }
}

