/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.expression;

import java.util.Locale;
import java.util.Objects;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.sql.JdbcValueExtractor;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.consume.spi.SqlAstWalker;
import org.hibernate.sql.ast.produce.spi.ColumnReferenceQualifier;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.sql.results.spi.SqlSelection;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class ColumnReference
implements Expression {
    private final Column column;
    private String sqlFragment;

    public ColumnReference(ColumnReferenceQualifier qualifier, Column column) {
        assert (qualifier != null) : "ColumnReferenceQualifier is null";
        this.column = column;
        this.sqlFragment = ColumnReference.renderSqlFragment(qualifier, column);
    }

    private static String renderSqlFragment(ColumnReferenceQualifier qualifier, Column column) {
        if (qualifier == null) {
            return column.render();
        }
        TableReference tableReference = qualifier.locateTableReference(column.getSourceTable());
        return column.render(tableReference.getIdentificationVariable());
    }

    public ColumnReference(Column column) {
        this.column = column;
        this.sqlFragment = ColumnReference.renderSqlFragment(null, column);
    }

    @Override
    public SqlSelection createSqlSelection(int jdbcPosition, int valuesArrayPosition, BasicJavaDescriptor javaTypeDescriptor, TypeConfiguration typeConfiguration) {
        JdbcValueExtractor jdbcValueExtractor = this.getColumn().getExpressableType().getJdbcValueExtractor();
        return new SqlSelectionImpl(jdbcPosition, valuesArrayPosition, (Expression)this, jdbcValueExtractor);
    }

    public Column getColumn() {
        return this.column;
    }

    public void accept(SqlAstWalker interpreter) {
        interpreter.visitColumnReference(this);
    }

    @Override
    public SqlExpressableType getType() {
        return this.column.getExpressableType();
    }

    public String renderSqlFragment() {
        return this.sqlFragment;
    }

    public String toString() {
        return String.format(Locale.ROOT, "%s(%s.%s)", this.getClass().getSimpleName(), this.sqlFragment, this.column.getExpression());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnReference that = (ColumnReference)o;
        return Objects.equals(this.sqlFragment, that.sqlFragment);
    }

    public int hashCode() {
        return Objects.hash(this.sqlFragment);
    }
}

