/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.expression;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.consume.spi.SqlAstWalker;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.GenericParameter;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;
import org.hibernate.sql.exec.spi.JdbcParameterBinding;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.sql.results.spi.SqlSelection;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class LiteralParameter
implements GenericParameter,
JdbcParameterBinding,
JdbcParameterBinder {
    private final Object value;
    private final SqlExpressableType type;

    public LiteralParameter(Object value, SqlExpressableType type, Clause clause, TypeConfiguration typeConfiguration) {
        this.value = value;
        this.type = type;
    }

    @Override
    public SqlExpressableType getExpressableType() {
        return this.type;
    }

    @Override
    public SqlSelection createSqlSelection(int jdbcPosition, int valuesArrayPosition, BasicJavaDescriptor javaTypeDescriptor, TypeConfiguration typeConfiguration) {
        return new SqlSelectionImpl(jdbcPosition, valuesArrayPosition, (Expression)this, this.getExpressableType());
    }

    @Override
    public JdbcParameterBinder getParameterBinder() {
        return this;
    }

    public void accept(SqlAstWalker sqlTreeWalker) {
        sqlTreeWalker.visitGenericParameter(this);
    }

    @Override
    public SqlExpressableType getBindType() {
        return this.getExpressableType();
    }

    @Override
    public Object getBindValue() {
        return this.value;
    }

    @Override
    public int bindParameterValue(PreparedStatement statement, int startPosition, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) throws SQLException {
        this.getExpressableType().getJdbcValueBinder().bind(statement, startPosition, this.value, executionContext);
        return 1;
    }

    @Override
    public SqlExpressableType getType() {
        return this.type;
    }
}

