/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.expression;

import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.consume.spi.SqlAstWalker;
import org.hibernate.sql.ast.tree.expression.AbstractStandardFunction;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.StandardFunction;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.sql.results.spi.SqlSelection;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class LocateFunction
extends AbstractStandardFunction
implements StandardFunction {
    private final Expression patternString;
    private final Expression stringToSearch;
    private final Expression startPosition;

    public LocateFunction(Expression patternString, Expression stringToSearch, Expression startPosition) {
        this.patternString = patternString;
        this.stringToSearch = stringToSearch;
        this.startPosition = startPosition;
    }

    public Expression getPatternString() {
        return this.patternString;
    }

    public Expression getStringToSearch() {
        return this.stringToSearch;
    }

    public Expression getStartPosition() {
        return this.startPosition;
    }

    public void accept(SqlAstWalker sqlTreeWalker) {
        sqlTreeWalker.visitLocateFunction(this);
    }

    @Override
    public SqlExpressableType getExpressableType() {
        return this.stringToSearch.getType();
    }

    @Override
    public SqlExpressableType getType() {
        return this.getExpressableType();
    }

    @Override
    public SqlSelection createSqlSelection(int jdbcPosition, int valuesArrayPosition, BasicJavaDescriptor javaTypeDescriptor, TypeConfiguration typeConfiguration) {
        return new SqlSelectionImpl(jdbcPosition, valuesArrayPosition, (Expression)this, this.getExpressableType());
    }
}

