/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.expression;

import java.util.Arrays;
import java.util.List;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.consume.spi.SqlAstWalker;
import org.hibernate.sql.ast.tree.expression.AbstractFunction;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.sql.results.spi.SqlSelection;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class NonStandardFunction
extends AbstractFunction {
    private final String functionName;
    private final List<Expression> arguments;
    private final SqlExpressableType resultType;

    public NonStandardFunction(String functionName, SqlExpressableType resultType, List<Expression> arguments) {
        this.functionName = functionName;
        this.arguments = arguments;
        this.resultType = resultType;
    }

    public NonStandardFunction(String functionName, SqlExpressableType resultType, Expression ... arguments) {
        this(functionName, resultType, Arrays.asList(arguments));
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public List<Expression> getArguments() {
        return this.arguments;
    }

    @Override
    public SqlExpressableType getExpressableType() {
        return this.resultType;
    }

    @Override
    public SqlExpressableType getType() {
        return this.resultType;
    }

    public void accept(SqlAstWalker walker) {
        walker.visitNonStandardFunctionExpression(this);
    }

    @Override
    public SqlSelection createSqlSelection(int jdbcPosition, int valuesArrayPosition, BasicJavaDescriptor javaTypeDescriptor, TypeConfiguration typeConfiguration) {
        return new SqlSelectionImpl(jdbcPosition, valuesArrayPosition, (Expression)this, this.getExpressableType());
    }
}

