/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.expression;

import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.TrimSpecification;
import org.hibernate.sql.ast.consume.spi.SqlAstWalker;
import org.hibernate.sql.ast.produce.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.tree.expression.AbstractStandardFunction;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.spi.StandardSpiBasicTypes;

public class TrimFunction
extends AbstractStandardFunction {
    private final TrimSpecification specification;
    private final Expression trimCharacter;
    private final Expression source;
    private final SqlExpressableType type;

    public TrimFunction(TrimSpecification specification, Expression trimCharacter, Expression source, SqlAstCreationContext creationContext) {
        this(specification, trimCharacter, source, StandardSpiBasicTypes.STRING.getSqlExpressableType(creationContext.getDomainModel().getTypeConfiguration()), creationContext);
    }

    public TrimFunction(TrimSpecification specification, Expression trimCharacter, Expression source, SqlExpressableType type, SqlAstCreationContext creationContext) {
        this.specification = specification;
        this.trimCharacter = trimCharacter;
        this.source = source;
        this.type = type;
    }

    public TrimSpecification getSpecification() {
        return this.specification;
    }

    public Expression getTrimCharacter() {
        return this.trimCharacter;
    }

    public Expression getSource() {
        return this.source;
    }

    public void accept(SqlAstWalker sqlTreeWalker) {
        sqlTreeWalker.visitTrimFunction(this);
    }

    @Override
    public SqlExpressableType getExpressableType() {
        return this.type;
    }

    @Override
    public SqlExpressableType getType() {
        return this.type;
    }
}

