/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.expression;

import org.hibernate.query.UnaryArithmeticOperator;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.consume.spi.SqlAstWalker;
import org.hibernate.sql.ast.produce.spi.SqlExpressable;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.results.internal.SqlSelectionImpl;
import org.hibernate.sql.results.internal.domain.basic.BasicResultImpl;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.sql.results.spi.DomainResultProducer;
import org.hibernate.sql.results.spi.SqlSelection;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class UnaryOperation
implements Expression,
SqlExpressable,
DomainResultProducer {
    private final UnaryArithmeticOperator operator;
    private final Expression operand;
    private final SqlExpressableType type;

    public UnaryOperation(UnaryArithmeticOperator operator, Expression operand, SqlExpressableType type) {
        this.operator = operator;
        this.operand = operand;
        this.type = type;
    }

    public UnaryArithmeticOperator getOperator() {
        return this.operator;
    }

    public Expression getOperand() {
        return this.operand;
    }

    @Override
    public SqlExpressableType getExpressableType() {
        return this.type;
    }

    @Override
    public SqlSelection createSqlSelection(int jdbcPosition, int valuesArrayPosition, BasicJavaDescriptor javaTypeDescriptor, TypeConfiguration typeConfiguration) {
        return new SqlSelectionImpl(jdbcPosition, valuesArrayPosition, (Expression)this, this.getExpressableType());
    }

    public void accept(SqlAstWalker walker) {
        walker.visitUnaryOperationExpression(this);
    }

    @Override
    public DomainResult createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        return new BasicResultImpl(resultVariable, creationState.getSqlExpressionResolver().resolveSqlSelection(this, this.getType().getJavaTypeDescriptor(), creationState.getSqlAstCreationState().getCreationContext().getDomainModel().getTypeConfiguration()), this.getType());
    }

    @Override
    public SqlExpressableType getType() {
        return this.type;
    }
}

