/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.expression.domain;

import java.util.function.Consumer;
import org.hibernate.metamodel.model.domain.spi.BasicValuedNavigable;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.produce.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.produce.spi.SqlAstCreationState;
import org.hibernate.sql.ast.produce.sqm.spi.SqmUpdateToSqlAstConverterMultiTable;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.domain.AssignableNavigableReference;
import org.hibernate.sql.ast.tree.expression.domain.NavigableReference;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;

public class BasicValuedNavigableReference
implements NavigableReference,
AssignableNavigableReference {
    private final NavigablePath navigablePath;
    private final BasicValuedNavigable referencedNavigable;

    public BasicValuedNavigableReference(NavigablePath navigablePath, BasicValuedNavigable referencedNavigable, SqlAstCreationState creationState) {
        this.navigablePath = navigablePath;
        this.referencedNavigable = referencedNavigable;
    }

    public BasicValuedNavigable getNavigable() {
        return this.referencedNavigable;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public void applySqlAssignments(Expression newValueExpression, SqmUpdateToSqlAstConverterMultiTable.AssignmentContext assignmentProcessingState, Consumer<Assignment> assignmentConsumer, SqlAstCreationContext creationContext) {
        Column column = this.referencedNavigable.getBoundColumn();
        TableReference tableReference = assignmentProcessingState.resolveTableReference(column.getSourceTable());
        assignmentConsumer.accept(new Assignment(tableReference.resolveColumnReference(column), newValueExpression));
    }

    @Override
    public void applySqlSelections(DomainResultCreationState creationState) {
        creationState.getSqlExpressionResolver().resolveSqlSelection(creationState.getSqlExpressionResolver().resolveSqlExpression(creationState.getFromClauseAccess().findTableGroup(this.getNavigablePath().getParent()), this.getNavigable().getBoundColumn()), (BasicJavaDescriptor)this.getNavigable().getJavaTypeDescriptor(), creationState.getSqlAstCreationState().getCreationContext().getDomainModel().getTypeConfiguration());
    }
}

