/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.expression.domain;

import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.metamodel.model.domain.spi.EmbeddedValuedNavigable;
import org.hibernate.metamodel.model.domain.spi.NavigableContainer;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.ast.produce.SyntaxException;
import org.hibernate.sql.ast.produce.spi.QualifiableSqlExpressable;
import org.hibernate.sql.ast.produce.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.produce.spi.SqlAstCreationState;
import org.hibernate.sql.ast.produce.spi.SqlExpressionResolver;
import org.hibernate.sql.ast.produce.sqm.spi.SqmUpdateToSqlAstConverterMultiTable;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.domain.AssignableNavigableReference;
import org.hibernate.sql.ast.tree.expression.domain.NavigableContainerReference;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.update.Assignment;
import org.hibernate.sql.results.spi.DomainResultCreationState;
import org.hibernate.type.spi.TypeConfiguration;

public class EmbeddableValuedNavigableReference
implements NavigableContainerReference,
AssignableNavigableReference {
    private final NavigablePath navigablePath;
    private final EmbeddedValuedNavigable<?> navigable;
    private final TableGroup ownerTableGroup;
    private final LockMode lockMode;

    public EmbeddableValuedNavigableReference(NavigablePath navigablePath, EmbeddedValuedNavigable navigable, LockMode lockMode, SqlAstCreationState creationState) {
        this.navigablePath = navigablePath;
        this.navigable = navigable;
        this.lockMode = lockMode;
        this.ownerTableGroup = creationState.getFromClauseAccess().findTableGroup(navigablePath.getParent());
        creationState.getFromClauseAccess().registerTableGroup(navigablePath, this.ownerTableGroup);
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public NavigableContainer<?> getNavigable() {
        return this.navigable;
    }

    @Override
    public void applySqlSelections(DomainResultCreationState creationState) {
        TypeConfiguration typeConfiguration = creationState.getSqlAstCreationState().getCreationContext().getDomainModel().getTypeConfiguration();
        SqlExpressionResolver sqlExpressionResolver = creationState.getSqlExpressionResolver();
        TableGroup tableGroup = creationState.getFromClauseAccess().findTableGroup(this.getNavigablePath().getParent());
        if (tableGroup == null) {
            throw new SyntaxException("Could not locate TableGroup : " + this.getNavigablePath().getFullPath());
        }
        this.getNavigable().visitColumns((sqlExpressableType, column) -> sqlExpressionResolver.resolveSqlSelection(sqlExpressionResolver.resolveSqlExpression(tableGroup, (QualifiableSqlExpressable)column), sqlExpressableType.getJavaTypeDescriptor(), typeConfiguration), Clause.SELECT, typeConfiguration);
    }

    @Override
    public void applySqlAssignments(Expression newValueExpression, SqmUpdateToSqlAstConverterMultiTable.AssignmentContext assignmentProcessingState, Consumer<Assignment> assignmentConsumer, SqlAstCreationContext creationContext) {
        throw new NotYetImplementedFor6Exception();
    }
}

