/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.expression.domain;

import org.hibernate.metamodel.model.domain.spi.DiscriminatorDescriptor;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.sql.SqlExpressableType;
import org.hibernate.sql.ast.consume.spi.SqlAstWalker;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.results.spi.SqlSelection;
import org.hibernate.type.descriptor.java.spi.BasicJavaDescriptor;
import org.hibernate.type.spi.TypeConfiguration;

public class EntityTypeLiteral
implements Expression {
    private final EntityTypeDescriptor<?> entityTypeDescriptor;
    private final DiscriminatorDescriptor<?> discriminatorDescriptor;

    public EntityTypeLiteral(EntityTypeDescriptor<?> entityTypeDescriptor) {
        this.entityTypeDescriptor = entityTypeDescriptor;
        this.discriminatorDescriptor = entityTypeDescriptor.getHierarchy().getDiscriminatorDescriptor();
    }

    public EntityTypeDescriptor<?> getEntityTypeDescriptor() {
        return this.entityTypeDescriptor;
    }

    public DiscriminatorDescriptor<?> getDiscriminatorDescriptor() {
        return this.discriminatorDescriptor;
    }

    @Override
    public SqlExpressableType getType() {
        return this.discriminatorDescriptor.getBoundColumn().getExpressableType();
    }

    @Override
    public SqlSelection createSqlSelection(int jdbcPosition, int valuesArrayPosition, BasicJavaDescriptor javaTypeDescriptor, TypeConfiguration typeConfiguration) {
        throw new UnsupportedOperationException("Entity-type literal not supported in select-clause");
    }

    public void accept(SqlAstWalker sqlTreeWalker) {
        sqlTreeWalker.visitEntityTypeLiteral(this);
    }
}

