/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.expression.domain;

import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.metamodel.model.domain.internal.SingularPersistentAttributeEntity;
import org.hibernate.metamodel.model.domain.spi.EntityIdentifier;
import org.hibernate.metamodel.model.domain.spi.EntityIdentifierSimple;
import org.hibernate.metamodel.model.domain.spi.EntityValuedNavigable;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.produce.spi.SqlAstCreationContext;
import org.hibernate.sql.ast.produce.spi.SqlAstCreationState;
import org.hibernate.sql.ast.produce.sqm.spi.SqmUpdateToSqlAstConverterMultiTable;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.domain.AssignableNavigableReference;
import org.hibernate.sql.ast.tree.expression.domain.NavigableContainerReference;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.update.Assignment;

public class EntityValuedNavigableReference
implements NavigableContainerReference,
AssignableNavigableReference {
    private final NavigablePath navigablePath;
    private final EntityValuedNavigable navigable;
    private final LockMode lockMode;

    public EntityValuedNavigableReference(NavigablePath navigablePath, EntityValuedNavigable navigable, LockMode lockMode, SqlAstCreationState creationState) {
        this.navigablePath = navigablePath;
        this.navigable = navigable;
        this.lockMode = lockMode;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public EntityValuedNavigable getNavigable() {
        return this.navigable;
    }

    public String toString() {
        return '`' + this.getNavigablePath().getFullPath() + '`';
    }

    @Override
    public void applySqlAssignments(Expression newValueExpression, SqmUpdateToSqlAstConverterMultiTable.AssignmentContext assignmentProcessingState, Consumer<Assignment> assignmentConsumer, SqlAstCreationContext creationContext) {
        EntityIdentifier identifierDescriptor;
        if (this.getNavigable() instanceof SingularPersistentAttributeEntity) {
            identifierDescriptor = this.getNavigable().getEntityDescriptor().getIdentifierDescriptor();
            if (!(identifierDescriptor instanceof EntityIdentifierSimple)) {
                throw new NotYetImplementedFor6Exception();
            }
        } else {
            throw new UnsupportedOperationException("Navigable type is not singular attribute : " + this.getNavigable());
        }
        Column boundColumn = ((EntityIdentifierSimple)identifierDescriptor).getBoundColumn();
        TableReference tableReference = assignmentProcessingState.resolveTableReference(boundColumn.getSourceTable());
        assignmentConsumer.accept(new Assignment(tableReference.resolveColumnReference(boundColumn), newValueExpression));
    }
}

