/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.expression.domain;

import java.util.List;
import org.hibernate.internal.util.Loggable;
import org.hibernate.metamodel.model.domain.spi.BasicValuedNavigable;
import org.hibernate.metamodel.model.domain.spi.Navigable;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.sqm.ParsingException;
import org.hibernate.sql.ast.produce.metamodel.spi.ExpressableType;
import org.hibernate.sql.ast.produce.spi.SqlAstCreationState;
import org.hibernate.sql.ast.produce.sqm.spi.SqmExpressionInterpretation;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.expression.SqlTuple;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.results.spi.DomainResult;
import org.hibernate.sql.results.spi.DomainResultCreationState;

public interface NavigableReference
extends SqmExpressionInterpretation,
Loggable {
    public NavigablePath getNavigablePath();

    public Navigable<?> getNavigable();

    default public ExpressableType getExpressableType() {
        return this.getNavigable();
    }

    @Override
    default public String toLoggableFragment() {
        return this.getNavigablePath().getFullPath();
    }

    @Override
    default public DomainResult createDomainResult(String resultVariable, DomainResultCreationState creationState) {
        return this.getNavigable().createDomainResult(this.getNavigablePath(), resultVariable, creationState);
    }

    @Override
    default public Expression toSqlExpression(SqlAstCreationState sqlAstCreationState) {
        TableGroup tableGroup;
        if (this.getNavigable() instanceof BasicValuedNavigable) {
            tableGroup = sqlAstCreationState.getFromClauseAccess().findTableGroup(this.getNavigablePath().getParent());
        } else {
            TableGroup thisTableGroup = sqlAstCreationState.getFromClauseAccess().findTableGroup(this.getNavigablePath());
            if (thisTableGroup != null) {
                tableGroup = thisTableGroup;
            } else {
                NavigablePath lhsNavigablePath = this.getNavigablePath().getParent();
                if (lhsNavigablePath == null) {
                    throw new ParsingException("Could not find TableGroup to use - " + this.getNavigablePath().getFullPath());
                }
                tableGroup = sqlAstCreationState.getFromClauseAccess().findTableGroup(lhsNavigablePath);
            }
        }
        List<ColumnReference> list = this.getNavigable().resolveColumnReferences(tableGroup, sqlAstCreationState);
        if (list.size() == 1) {
            if (!1.$assertionsDisabled && !(list.get(0) instanceof Expression)) {
                throw new AssertionError();
            }
            return list.get(0);
        }
        return new SqlTuple(list, this.getExpressableType());
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

