/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.metamodel.model.domain.spi.Navigable;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.consume.spi.SqlAppender;
import org.hibernate.sql.ast.consume.spi.SqlAstWalker;
import org.hibernate.sql.ast.produce.metamodel.spi.AbstractColumnReferenceQualifier;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableGroupJoin;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;

public abstract class AbstractTableGroup
extends AbstractColumnReferenceQualifier
implements TableGroup {
    private final NavigablePath navigablePath;
    private final Navigable<?> navigable;
    private final LockMode lockMode;
    private Set<TableGroupJoin> tableGroupJoins;
    private boolean isInnerJoinPossible = true;

    public AbstractTableGroup(NavigablePath navigablePath, Navigable<?> navigable, LockMode lockMode) {
        this.navigablePath = navigablePath;
        this.navigable = navigable;
        this.lockMode = lockMode;
    }

    public AbstractTableGroup(NavigablePath navigablePath, Navigable<?> navigable, LockMode lockMode, boolean isInnerJoinPossible) {
        this.navigablePath = navigablePath;
        this.navigable = navigable;
        this.lockMode = lockMode;
        this.isInnerJoinPossible = isInnerJoinPossible;
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public Navigable<?> getNavigable() {
        return this.navigable;
    }

    @Override
    public LockMode getLockMode() {
        return this.lockMode;
    }

    @Override
    public Set<TableGroupJoin> getTableGroupJoins() {
        return this.tableGroupJoins == null ? Collections.emptySet() : Collections.unmodifiableSet(this.tableGroupJoins);
    }

    @Override
    public boolean hasTableGroupJoins() {
        return this.tableGroupJoins != null && !this.tableGroupJoins.isEmpty();
    }

    @Override
    public void setTableGroupJoins(Set<TableGroupJoin> joins) {
        this.tableGroupJoins.addAll(joins);
    }

    @Override
    public void addTableGroupJoin(TableGroupJoin join) {
        if (this.tableGroupJoins == null) {
            this.tableGroupJoins = new HashSet<TableGroupJoin>();
        }
        this.tableGroupJoins.add(join);
    }

    @Override
    public void visitTableGroupJoins(Consumer<TableGroupJoin> consumer) {
        if (this.tableGroupJoins != null) {
            this.tableGroupJoins.forEach(consumer);
        }
    }

    protected void renderTableReference(TableReference tableBinding, SqlAppender sqlAppender, SqlAstWalker walker) {
        String identificationVariable = tableBinding.getIdentificationVariable();
        String aliasString = "";
        if (identificationVariable != null) {
            aliasString = " as " + identificationVariable;
        }
        sqlAppender.appendSql(tableBinding.getTable().render(walker.getSessionFactory().getDialect(), walker.getSessionFactory().getJdbcServices().getJdbcEnvironment()) + aliasString);
    }

    @Override
    public String toLoggableFragment() {
        StringBuilder buffer = new StringBuilder("(");
        buffer.append("path=(").append(this.getNavigablePath()).append("), ");
        buffer.append("root=(").append(this.getPrimaryTableReference().toLoggableFragment()).append("), ");
        buffer.append("joins=[");
        if (this.getTableReferenceJoins() != null) {
            boolean firstPass = true;
            for (TableReferenceJoin tableReferenceJoin : this.getTableReferenceJoins()) {
                if (firstPass) {
                    firstPass = false;
                } else {
                    buffer.append(',');
                }
                buffer.append(tableReferenceJoin.toLoggableFragment());
            }
        }
        return buffer.append("])").toString();
    }

    @Override
    public boolean isInnerJoinPossible() {
        return this.isInnerJoinPossible;
    }
}

