/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.hibernate.LockMode;
import org.hibernate.metamodel.model.domain.spi.Navigable;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.metamodel.model.relational.spi.Table;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.ast.consume.spi.SqlAppender;
import org.hibernate.sql.ast.consume.spi.SqlAstWalker;
import org.hibernate.sql.ast.produce.spi.ColumnReferenceQualifier;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.from.AbstractTableGroup;
import org.hibernate.sql.ast.tree.from.TableGroup;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.from.TableReferenceJoin;

public class StandardTableGroup
extends AbstractTableGroup {
    private final TableReference primaryTableReference;
    private final List<TableReferenceJoin> tableReferenceJoins;
    private final ColumnReferenceQualifier additionalQualifier;

    public StandardTableGroup(NavigablePath navigablePath, Navigable<?> navigable, LockMode lockMode, TableReference primaryTableReference, List<TableReferenceJoin> tableReferenceJoins) {
        this(navigablePath, navigable, lockMode, primaryTableReference, tableReferenceJoins, null);
    }

    public StandardTableGroup(NavigablePath navigablePath, Navigable navigable, LockMode lockMode, TableReference primaryTableReference, List<TableReferenceJoin> tableReferenceJoins, TableGroup additionalQualifier) {
        super(navigablePath, navigable, lockMode, additionalQualifier == null ? true : additionalQualifier.isInnerJoinPossible());
        this.primaryTableReference = primaryTableReference;
        this.tableReferenceJoins = tableReferenceJoins;
        this.additionalQualifier = additionalQualifier;
    }

    @Override
    public TableReference getPrimaryTableReference() {
        return this.primaryTableReference;
    }

    @Override
    public List<TableReferenceJoin> getTableReferenceJoins() {
        return this.tableReferenceJoins;
    }

    @Override
    public void applyAffectedTableNames(Consumer<String> nameCollector) {
        nameCollector.accept(this.primaryTableReference.getTable().getTableExpression());
        for (TableReferenceJoin tableReferenceJoin : this.tableReferenceJoins) {
            nameCollector.accept(tableReferenceJoin.getJoinedTableReference().getTable().getTableExpression());
        }
    }

    @Override
    public TableReference locateTableReference(Table table) {
        if (table == this.primaryTableReference.getTable()) {
            return this.primaryTableReference;
        }
        if (this.tableReferenceJoins != null) {
            for (TableReferenceJoin tableJoin : this.tableReferenceJoins) {
                if (tableJoin.getJoinedTableReference().getTable() != table) continue;
                return tableJoin.getJoinedTableReference();
            }
        }
        if (this.additionalQualifier != null) {
            return this.additionalQualifier.locateTableReference(table);
        }
        return null;
    }

    @Override
    public ColumnReference resolveColumnReference(Column column) {
        return super.resolveColumnReference(column);
    }

    @Override
    public Column resolveColumn(String name) {
        Column column = this.getPrimaryTableReference().getTable().getColumn(name);
        if (column == null) {
            TableReferenceJoin join;
            Iterator<TableReferenceJoin> iterator = this.getTableReferenceJoins().iterator();
            while (iterator.hasNext() && (column = (join = iterator.next()).getJoinedTableReference().getTable().getColumn(name)) == null) {
            }
        }
        if (column == null && this.additionalQualifier != null) {
            column = this.additionalQualifier.resolveColumn(name);
        }
        return column;
    }

    @Override
    public ColumnReference locateColumnReferenceByName(String name) {
        Column column = this.resolveColumn(name);
        if (column == null) {
            return null;
        }
        return this.resolveColumnReference(column);
    }

    @Override
    public void render(SqlAppender sqlAppender, SqlAstWalker walker) {
        this.renderTableReference(this.primaryTableReference, sqlAppender, walker);
        if (this.tableReferenceJoins != null) {
            for (TableReferenceJoin tableJoin : this.tableReferenceJoins) {
                sqlAppender.appendSql(" ");
                sqlAppender.appendSql(tableJoin.getJoinType().getText());
                sqlAppender.appendSql(" join ");
                this.renderTableReference(tableJoin.getJoinedTableReference(), sqlAppender, walker);
                if (tableJoin.getJoinPredicate() == null || tableJoin.getJoinPredicate().isEmpty()) continue;
                sqlAppender.appendSql(" on ");
                tableJoin.getJoinPredicate().accept(walker);
            }
        }
    }
}

