/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.hibernate.internal.util.Loggable;
import org.hibernate.metamodel.model.relational.spi.Column;
import org.hibernate.metamodel.model.relational.spi.Table;
import org.hibernate.sql.ast.consume.spi.SqlAstWalker;
import org.hibernate.sql.ast.produce.spi.ColumnReferenceQualifier;
import org.hibernate.sql.ast.produce.spi.QualifiableSqlExpressable;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.ColumnReference;
import org.hibernate.sql.ast.tree.expression.Expression;

public class TableReference
implements SqlAstNode,
ColumnReferenceQualifier,
Loggable {
    private final Table table;
    private final String identificationVariable;
    private final boolean isOptional;
    private final Map<Column, ColumnReference> columnReferenceResolutionMap = new HashMap<Column, ColumnReference>();

    public TableReference(Table table, String identificationVariable, boolean isOptional) {
        this.table = table;
        this.identificationVariable = identificationVariable;
        this.isOptional = isOptional;
    }

    public Table getTable() {
        return this.table;
    }

    public String getIdentificationVariable() {
        return this.identificationVariable;
    }

    public boolean isOptional() {
        return this.isOptional;
    }

    @Override
    public TableReference locateTableReference(Table table) {
        if (table.equals(this.getTable())) {
            return this;
        }
        return null;
    }

    @Override
    public ColumnReference resolveColumnReference(Column column) {
        ColumnReference existing = this.columnReferenceResolutionMap.get(column);
        if (existing != null) {
            return existing;
        }
        ColumnReference columnReference = new ColumnReference(this, column);
        this.columnReferenceResolutionMap.put(column, columnReference);
        return columnReference;
    }

    @Override
    public ColumnReference resolveColumnReference(String columnName) {
        return this.resolveColumnReference(this.getTable().getColumn(columnName));
    }

    @Override
    public Column resolveColumn(String columnName) {
        return this.getTable().getColumn(columnName);
    }

    public void accept(SqlAstWalker sqlTreeWalker) {
        sqlTreeWalker.visitTableReference(this);
    }

    @Override
    public Expression qualify(QualifiableSqlExpressable sqlSelectable) {
        assert (sqlSelectable instanceof Column);
        return this.resolveColumnReference((Column)sqlSelectable);
    }

    @Override
    public String toLoggableFragment() {
        return this.getTable().toLoggableFragment() + "(" + this.getIdentificationVariable() + ')';
    }

    public String toString() {
        return this.toLoggableFragment();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TableReference that = (TableReference)o;
        return Objects.equals(this.identificationVariable, that.identificationVariable);
    }

    public int hashCode() {
        return Objects.hash(this.identificationVariable);
    }
}

