/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.from;

import org.hibernate.internal.util.Loggable;
import org.hibernate.sql.ast.JoinType;
import org.hibernate.sql.ast.consume.spi.SqlAstWalker;
import org.hibernate.sql.ast.produce.IllegalJoinSpecificationException;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.from.TableReference;
import org.hibernate.sql.ast.tree.predicate.Predicate;

public class TableReferenceJoin
implements SqlAstNode,
Loggable {
    private final JoinType joinType;
    private final TableReference joinedTableBinding;
    private final Predicate predicate;

    public TableReferenceJoin(JoinType joinType, TableReference joinedTableBinding, Predicate predicate) {
        this.joinType = joinType;
        this.joinedTableBinding = joinedTableBinding;
        this.predicate = predicate;
        if (joinType == JoinType.CROSS && predicate != null) {
            throw new IllegalJoinSpecificationException("Cross join cannot include join predicate");
        }
    }

    public JoinType getJoinType() {
        return this.joinType;
    }

    public TableReference getJoinedTableReference() {
        return this.joinedTableBinding;
    }

    public Predicate getJoinPredicate() {
        return this.predicate;
    }

    public void accept(SqlAstWalker sqlTreeWalker) {
        sqlTreeWalker.visitTableReferenceJoin(this);
    }

    @Override
    public String toLoggableFragment() {
        return this.getJoinType().getText() + " join " + this.getJoinedTableReference().toLoggableFragment();
    }
}

