/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.select;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hibernate.sql.ast.consume.spi.SqlAstWalker;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.sql.ast.tree.from.FromClause;
import org.hibernate.sql.ast.tree.predicate.Junction;
import org.hibernate.sql.ast.tree.predicate.Predicate;
import org.hibernate.sql.ast.tree.select.SelectClause;
import org.hibernate.sql.ast.tree.sort.SortSpecification;

public class QuerySpec
implements SqlAstNode {
    private final boolean isRoot;
    private final FromClause fromClause = new FromClause();
    private final SelectClause selectClause = new SelectClause();
    private Predicate whereClauseRestrictions;
    private List<SortSpecification> sortSpecifications;
    private Expression limitClauseExpression;
    private Expression offsetClauseExpression;

    public QuerySpec(boolean isRoot) {
        this.isRoot = isRoot;
    }

    public boolean isRoot() {
        return this.isRoot;
    }

    public FromClause getFromClause() {
        return this.fromClause;
    }

    public SelectClause getSelectClause() {
        return this.selectClause;
    }

    public Predicate getWhereClauseRestrictions() {
        return this.whereClauseRestrictions;
    }

    public void setWhereClauseRestrictions(Predicate whereClauseRestrictions) {
        if (this.whereClauseRestrictions != null) {
            throw new UnsupportedOperationException("Cannot set where-clause restrictions after already set; try #addRestriction");
        }
        this.whereClauseRestrictions = whereClauseRestrictions;
    }

    public void addRestriction(Predicate predicate) {
        if (this.whereClauseRestrictions == null) {
            this.whereClauseRestrictions = predicate;
        } else if (this.whereClauseRestrictions instanceof Junction && ((Junction)this.whereClauseRestrictions).getNature() == Junction.Nature.CONJUNCTION) {
            ((Junction)this.whereClauseRestrictions).add(predicate);
        } else {
            Junction conjunction = new Junction(Junction.Nature.CONJUNCTION);
            conjunction.add(this.whereClauseRestrictions);
            conjunction.add(predicate);
            this.whereClauseRestrictions = conjunction;
        }
    }

    public List<SortSpecification> getSortSpecifications() {
        if (this.sortSpecifications == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.sortSpecifications);
    }

    public void addSortSpecification(SortSpecification sortSpecification) {
        if (this.sortSpecifications == null) {
            this.sortSpecifications = new ArrayList<SortSpecification>();
        }
        this.sortSpecifications.add(sortSpecification);
    }

    public Expression getLimitClauseExpression() {
        return this.limitClauseExpression;
    }

    public void setLimitClauseExpression(Expression limitExpression) {
        if (this.limitClauseExpression != null) {
            throw new UnsupportedOperationException("Cannot set limit-clause expression after already set");
        }
        this.limitClauseExpression = limitExpression;
    }

    public Expression getOffsetClauseExpression() {
        return this.offsetClauseExpression;
    }

    public void setOffsetClauseExpression(Expression offsetExpression) {
        if (this.offsetClauseExpression != null) {
            throw new UnsupportedOperationException("Cannot set offset-clause expression after already set");
        }
        this.offsetClauseExpression = offsetExpression;
    }

    public void accept(SqlAstWalker sqlTreeWalker) {
        sqlTreeWalker.visitQuerySpec(this);
    }
}

