/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ast.tree.select;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.hibernate.internal.util.collections.UniqueList;
import org.hibernate.sql.ast.consume.spi.SqlAstWalker;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.results.spi.SqlSelection;

public class SelectClause
implements SqlAstNode {
    private boolean distinct;
    private final UniqueList<SqlSelection> sqlSelections = new UniqueList();

    public void makeDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public boolean isDistinct() {
        return this.distinct;
    }

    public List<SqlSelection> getSqlSelectionList() {
        return Collections.unmodifiableList(this.sqlSelections);
    }

    public Set<SqlSelection> getSqlSelections() {
        return Collections.unmodifiableSet(this.sqlSelections);
    }

    public void addSqlSelection(SqlSelection sqlSelection) {
        this.sqlSelections.add(sqlSelection);
    }

    public void accept(SqlAstWalker sqlTreeWalker) {
        sqlTreeWalker.visitSelectClause(this);
    }
}

