/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.exec.internal;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.concurrent.atomic.AtomicInteger;
import org.hibernate.metamodel.model.domain.spi.AllowableParameterType;
import org.hibernate.sql.ast.Clause;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.type.spi.TypeConfiguration;
import org.jboss.logging.Logger;

public class JdbcCallParameterBinderImpl
implements JdbcParameterBinder {
    private static final Logger log = Logger.getLogger(JdbcCallParameterBinderImpl.class);
    private final String callName;
    private final String parameterName;
    private final int parameterPosition;
    private final AllowableParameterType ormType;
    private final TypeConfiguration typeConfiguration;

    public JdbcCallParameterBinderImpl(String callName, String parameterName, int parameterPosition, AllowableParameterType ormType, TypeConfiguration typeConfiguration) {
        this.callName = callName;
        this.parameterName = parameterName;
        this.parameterPosition = parameterPosition;
        this.ormType = ormType;
        this.typeConfiguration = typeConfiguration;
    }

    @Override
    public int bindParameterValue(PreparedStatement statement, int startPosition, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) throws SQLException {
        Object binding = this.parameterName != null ? executionContext.getDomainParameterBindingContext().getQueryParameterBindings().getBinding(this.parameterName) : executionContext.getDomainParameterBindingContext().getQueryParameterBindings().getBinding(this.parameterPosition);
        if (binding == null) {
            log.debugf("Stored procedure [%s] IN/INOUT parameter [%s] not bound; skipping binding (assuming procedure defines default value)", (Object)this.callName, (Object)(this.parameterName == null ? Integer.toString(this.parameterPosition) : this.parameterName));
        } else {
            Object bindValue = binding.getBindValue();
            if (bindValue == null) {
                log.debugf("Binding NULL to IN/INOUT parameter [%s] for stored procedure `%s`", (Object)(this.parameterName == null ? Integer.toString(this.parameterPosition) : this.parameterName), (Object)this.callName);
            } else {
                log.debugf("Binding [%s] to IN/INOUT parameter [%s] for stored procedure `%s`", bindValue, (Object)(this.parameterName == null ? Integer.toString(this.parameterPosition) : this.parameterName), (Object)this.callName);
            }
            AtomicInteger count = new AtomicInteger();
            if (this.parameterName != null && this.ormType.getNumberOfJdbcParametersNeeded() == 1) {
                this.ormType.dehydrate(this.ormType.unresolve(bindValue, executionContext.getSession()), (jdbcValue, type, boundColumn) -> {
                    try {
                        type.getJdbcValueBinder().bind((CallableStatement)statement, this.parameterName, jdbcValue, executionContext);
                    }
                    catch (SQLException e) {
                        executionContext.getSession().getJdbcServices().getSqlExceptionHelper().convert(e, "Unable to bind callable parameter value by name [" + this.parameterName + "] - " + jdbcValue, this.callName);
                    }
                }, Clause.CALL, executionContext.getSession());
                return 1;
            }
            this.ormType.dehydrate(this.ormType.unresolve(bindValue, executionContext.getSession()), (jdbcValue, type, boundColumn) -> {
                int position = count.getAndIncrement();
                try {
                    type.getJdbcValueBinder().bind(statement, position, jdbcValue, executionContext);
                }
                catch (SQLException e) {
                    executionContext.getSession().getJdbcServices().getSqlExceptionHelper().convert(e, "Unable to bind callable parameter value by position [" + position + "] - " + jdbcValue, this.callName);
                }
            }, Clause.CALL, executionContext.getSession());
        }
        return this.ormType.getNumberOfJdbcParametersNeeded();
    }
}

