/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.exec.internal;

import java.sql.CallableStatement;
import java.sql.SQLException;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.metamodel.model.domain.spi.AllowableParameterType;
import org.hibernate.sql.JdbcValueExtractor;
import org.hibernate.sql.ast.produce.metamodel.spi.BasicValuedExpressableType;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcCallParameterExtractor;

public class JdbcCallParameterExtractorImpl<T>
implements JdbcCallParameterExtractor {
    private final String callableName;
    private final String parameterName;
    private final int parameterPosition;
    private final BasicValuedExpressableType ormType;

    public JdbcCallParameterExtractorImpl(String callableName, String parameterName, int parameterPosition, AllowableParameterType ormType) {
        if (!(ormType instanceof BasicValuedExpressableType)) {
            throw new NotYetImplementedFor6Exception("Support for JDBC CallableStatement parameter extraction not yet supported for non-basic types");
        }
        this.callableName = callableName;
        this.parameterName = parameterName;
        this.parameterPosition = parameterPosition;
        this.ormType = (BasicValuedExpressableType)ormType;
    }

    @Override
    public String getParameterName() {
        return this.parameterName;
    }

    @Override
    public int getParameterPosition() {
        return this.parameterPosition;
    }

    @Override
    public T extractValue(CallableStatement callableStatement, boolean shouldUseJdbcNamedParameters, ExecutionContext executionContext) {
        boolean useNamed = shouldUseJdbcNamedParameters && this.parameterName != null;
        JdbcValueExtractor valueExtractor = this.ormType.getSqlExpressableType().getJdbcValueExtractor();
        try {
            if (useNamed) {
                return (T)valueExtractor.extract(callableStatement, this.parameterName, executionContext);
            }
            return (T)valueExtractor.extract(callableStatement, this.parameterPosition, executionContext);
        }
        catch (SQLException e) {
            throw executionContext.getSession().getJdbcServices().getSqlExceptionHelper().convert(e, "Unable to extract OUT/INOUT parameter value");
        }
    }
}

