/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.exec.internal;

import java.sql.CallableStatement;
import java.sql.SQLException;
import javax.persistence.ParameterMode;
import org.hibernate.engine.jdbc.cursor.spi.RefCursorSupport;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.spi.AllowableParameterType;
import org.hibernate.sql.ast.produce.metamodel.spi.BasicValuedExpressableType;
import org.hibernate.sql.exec.internal.JdbcCallParameterExtractorImpl;
import org.hibernate.sql.exec.internal.JdbcCallRefCursorExtractorImpl;
import org.hibernate.sql.exec.spi.JdbcCallParameterExtractor;
import org.hibernate.sql.exec.spi.JdbcCallParameterRegistration;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;
import org.hibernate.type.descriptor.sql.spi.SqlTypeDescriptor;

public class JdbcCallParameterRegistrationImpl
implements JdbcCallParameterRegistration {
    private final String name;
    private final int jdbcParameterPositionStart;
    private final ParameterMode parameterMode;
    private final int jdbcTypeCode;
    private final AllowableParameterType ormType;
    private final JdbcParameterBinder parameterBinder;
    private final JdbcCallParameterExtractorImpl parameterExtractor;
    private final JdbcCallRefCursorExtractorImpl refCursorExtractor;

    public JdbcCallParameterRegistrationImpl(String name, int jdbcParameterPositionStart, ParameterMode parameterMode, int jdbcTypeCode, AllowableParameterType ormType, JdbcParameterBinder parameterBinder, JdbcCallParameterExtractorImpl parameterExtractor, JdbcCallRefCursorExtractorImpl refCursorExtractor) {
        this.name = name;
        this.jdbcParameterPositionStart = jdbcParameterPositionStart;
        this.parameterMode = parameterMode;
        this.jdbcTypeCode = jdbcTypeCode;
        this.ormType = ormType;
        this.parameterBinder = parameterBinder;
        this.parameterExtractor = parameterExtractor;
        this.refCursorExtractor = refCursorExtractor;
    }

    @Override
    public JdbcParameterBinder getParameterBinder() {
        return this.parameterBinder;
    }

    @Override
    public JdbcCallParameterExtractor getParameterExtractor() {
        return this.parameterExtractor;
    }

    @Override
    public JdbcCallRefCursorExtractorImpl getRefCursorExtractor() {
        return this.refCursorExtractor;
    }

    @Override
    public ParameterMode getParameterMode() {
        return this.parameterMode;
    }

    @Override
    public AllowableParameterType getParameterType() {
        return this.ormType;
    }

    @Override
    public void registerParameter(CallableStatement callableStatement, SharedSessionContractImplementor session) {
        switch (this.parameterMode) {
            case REF_CURSOR: {
                this.registerRefCursorParameter(callableStatement, session);
                break;
            }
            case IN: {
                break;
            }
            default: {
                this.registerOutputParameter(callableStatement, session);
            }
        }
    }

    private void registerRefCursorParameter(CallableStatement callableStatement, SharedSessionContractImplementor session) {
        if (this.name != null) {
            session.getFactory().getServiceRegistry().getService(RefCursorSupport.class).registerRefCursorParameter(callableStatement, this.name);
        } else {
            session.getFactory().getServiceRegistry().getService(RefCursorSupport.class).registerRefCursorParameter(callableStatement, this.jdbcParameterPositionStart);
        }
    }

    private void registerOutputParameter(CallableStatement callableStatement, SharedSessionContractImplementor session) {
        SqlTypeDescriptor sqlTypeDescriptor = ((BasicValuedExpressableType)this.ormType).getSqlTypeDescriptor();
        try {
            if (this.name != null) {
                callableStatement.registerOutParameter(this.name, sqlTypeDescriptor.getJdbcTypeCode());
            } else {
                callableStatement.registerOutParameter(this.jdbcParameterPositionStart, sqlTypeDescriptor.getJdbcTypeCode());
            }
        }
        catch (SQLException e) {
            throw session.getJdbcServices().getSqlExceptionHelper().convert(e, "Unable to register CallableStatement out parameter");
        }
    }
}

