/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.exec.internal;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.resource.jdbc.spi.LogicalConnectionImplementor;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcMutation;
import org.hibernate.sql.exec.spi.JdbcMutationExecutor;
import org.hibernate.sql.exec.spi.JdbcParameterBinder;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;

public class JdbcMutationExecutorImpl
implements JdbcMutationExecutor {
    private final boolean callAfterStatement;

    public JdbcMutationExecutorImpl(boolean callAfterStatement) {
        this.callAfterStatement = callAfterStatement;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute(JdbcMutation jdbcMutation, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext, Function<String, PreparedStatement> statementCreator, BiConsumer<Integer, PreparedStatement> expectationCkeck) {
        LogicalConnectionImplementor logicalConnection = executionContext.getSession().getJdbcCoordinator().getLogicalConnection();
        JdbcServices jdbcServices = executionContext.getSession().getFactory().getServiceRegistry().getService(JdbcServices.class);
        String sql = jdbcMutation.getSql();
        try {
            PreparedStatement preparedStatement = statementCreator.apply(sql);
            try {
                if (executionContext.getQueryOptions().getTimeout() != null) {
                    preparedStatement.setQueryTimeout(executionContext.getQueryOptions().getTimeout());
                }
                int paramBindingPosition = 1;
                for (JdbcParameterBinder parameterBinder : jdbcMutation.getParameterBinders()) {
                    paramBindingPosition += parameterBinder.bindParameterValue(preparedStatement, paramBindingPosition, jdbcParameterBindings, executionContext);
                }
                int rows = preparedStatement.executeUpdate();
                expectationCkeck.accept(rows, preparedStatement);
                int n = rows;
                logicalConnection.getResourceRegistry().release(preparedStatement);
                return n;
            }
            catch (Throwable throwable) {
                try {
                    logicalConnection.getResourceRegistry().release(preparedStatement);
                    throw throwable;
                }
                catch (SQLException e) {
                    throw jdbcServices.getSqlExceptionHelper().convert(e, "JDBC exception executing SQL [" + sql + "]");
                }
            }
        }
        finally {
            if (this.callAfterStatement) {
                logicalConnection.afterStatement();
            }
        }
    }

    @Override
    public int execute(JdbcMutation jdbcMutation, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext, Function<String, PreparedStatement> statementCreator) {
        return this.execute(jdbcMutation, jdbcParameterBindings, executionContext, statementCreator, (integer, preparedStatement) -> {});
    }

    @Override
    public int execute(JdbcMutation jdbcMutation, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext, BiConsumer<Integer, PreparedStatement> expectationCkeck) {
        return this.execute(jdbcMutation, jdbcParameterBindings, executionContext, sql -> executionContext.getSession().getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), expectationCkeck);
    }

    @Override
    public int execute(JdbcMutation jdbcMutation, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext) {
        return this.execute(jdbcMutation, jdbcParameterBindings, executionContext, (String sql) -> executionContext.getSession().getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql));
    }
}

