/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.exec.internal;

import java.io.Serializable;
import java.sql.PreparedStatement;
import java.util.ArrayList;
import java.util.List;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.hibernate.CacheMode;
import org.hibernate.ScrollMode;
import org.hibernate.cache.spi.QueryKey;
import org.hibernate.cache.spi.QueryResultsCache;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.loader.spi.AfterLoadAction;
import org.hibernate.query.internal.ScrollableResultsIterator;
import org.hibernate.query.spi.ScrollableResultsImplementor;
import org.hibernate.sql.exec.internal.Helper;
import org.hibernate.sql.exec.internal.ListResultsConsumer;
import org.hibernate.sql.exec.internal.ResultsConsumer;
import org.hibernate.sql.exec.internal.ScrollableResultsConsumer;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcSelect;
import org.hibernate.sql.exec.spi.JdbcSelectExecutor;
import org.hibernate.sql.exec.spi.RowTransformer;
import org.hibernate.sql.results.internal.JdbcValuesSourceProcessingStateStandardImpl;
import org.hibernate.sql.results.internal.RowProcessingStateStandardImpl;
import org.hibernate.sql.results.internal.values.DeferredResultSetAccess;
import org.hibernate.sql.results.internal.values.JdbcValues;
import org.hibernate.sql.results.internal.values.JdbcValuesCacheHit;
import org.hibernate.sql.results.internal.values.JdbcValuesResultSetImpl;
import org.hibernate.sql.results.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.spi.ResultSetAccess;
import org.hibernate.sql.results.spi.ResultSetMapping;
import org.hibernate.sql.results.spi.RowReader;
import org.jboss.logging.Logger;

public class JdbcSelectExecutorStandardImpl
implements JdbcSelectExecutor {
    public static final JdbcSelectExecutorStandardImpl INSTANCE = new JdbcSelectExecutorStandardImpl();
    private static final Logger log = Logger.getLogger(JdbcSelectExecutorStandardImpl.class);

    @Override
    public <R> List<R> list(JdbcSelect jdbcSelect, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext, RowTransformer<R> rowTransformer) {
        return (List)this.executeQuery(jdbcSelect, jdbcParameterBindings, executionContext, rowTransformer, sql -> executionContext.getSession().getJdbcCoordinator().getStatementPreparer().prepareStatement((String)sql), ListResultsConsumer.instance());
    }

    @Override
    public <R> ScrollableResultsImplementor<R> scroll(JdbcSelect jdbcSelect, ScrollMode scrollMode, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext, RowTransformer<R> rowTransformer) {
        return (ScrollableResultsImplementor)this.executeQuery(jdbcSelect, jdbcParameterBindings, executionContext, rowTransformer, sql -> executionContext.getSession().getJdbcCoordinator().getStatementPreparer().prepareQueryStatement((String)sql, scrollMode, true), ScrollableResultsConsumer.instance());
    }

    @Override
    public <R> Stream<R> stream(JdbcSelect jdbcSelect, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext, RowTransformer<R> rowTransformer) {
        ScrollableResultsImplementor<R> scrollableResults = this.scroll(jdbcSelect, ScrollMode.FORWARD_ONLY, jdbcParameterBindings, executionContext, rowTransformer);
        ScrollableResultsIterator iterator = new ScrollableResultsIterator(scrollableResults);
        Spliterator spliterator = Spliterators.spliteratorUnknownSize(iterator, 256);
        Stream stream = StreamSupport.stream(spliterator, false);
        return (Stream)stream.onClose(scrollableResults::close);
    }

    private <T, R> T executeQuery(JdbcSelect jdbcSelect, JdbcParameterBindings jdbcParameterBindings, ExecutionContext executionContext, RowTransformer<R> rowTransformer, Function<String, PreparedStatement> statementCreator, ResultsConsumer<T, R> resultsConsumer) {
        JdbcValues jdbcValues = this.resolveJdbcValuesSource(jdbcSelect, executionContext, new DeferredResultSetAccess(jdbcSelect, jdbcParameterBindings, executionContext, statementCreator));
        JdbcValuesSourceProcessingOptions processingOptions = new JdbcValuesSourceProcessingOptions(){

            @Override
            public Object getEffectiveOptionalObject() {
                return null;
            }

            @Override
            public String getEffectiveOptionalEntityName() {
                return null;
            }

            @Override
            public Serializable getEffectiveOptionalId() {
                return null;
            }

            @Override
            public boolean shouldReturnProxies() {
                return true;
            }
        };
        JdbcValuesSourceProcessingStateStandardImpl jdbcValuesSourceProcessingState = new JdbcValuesSourceProcessingStateStandardImpl(executionContext, processingOptions);
        ArrayList afterLoadActions = new ArrayList();
        RowReader<R> rowReader = Helper.createRowReader((SessionFactoryImplementor)executionContext.getSession().getSessionFactory(), afterLoadActions::add, rowTransformer, jdbcValues);
        RowProcessingStateStandardImpl rowProcessingState = new RowProcessingStateStandardImpl(jdbcValuesSourceProcessingState, executionContext.getQueryOptions(), rowReader, jdbcValues);
        T result = resultsConsumer.consume(jdbcValues, executionContext.getSession(), processingOptions, jdbcValuesSourceProcessingState, rowProcessingState, rowReader);
        for (AfterLoadAction afterLoadAction : afterLoadActions) {
            afterLoadAction.afterLoad(executionContext.getSession());
        }
        return result;
    }

    private JdbcValues resolveJdbcValuesSource(JdbcSelect jdbcSelect, ExecutionContext executionContext, ResultSetAccess resultSetAccess) {
        List cachedResults;
        QueryKey queryResultsCacheKey;
        boolean queryCacheEnabled = executionContext.getSession().getFactory().getSessionFactoryOptions().isQueryCacheEnabled();
        CacheMode cacheMode = this.resolveCacheMode(executionContext);
        ResultSetMapping resultSetMapping = jdbcSelect.getResultSetMapping().resolve(resultSetAccess, (SessionFactoryImplementor)executionContext.getSession().getSessionFactory());
        if (queryCacheEnabled && cacheMode.isGetEnabled()) {
            log.debugf("Reading Query result cache data per CacheMode#isGetEnabled [%s]", (Object)cacheMode.name());
            QueryResultsCache queryCache = executionContext.getSession().getFactory().getCache().getQueryResultsCache(executionContext.getQueryOptions().getResultCacheRegionName());
            queryResultsCacheKey = QueryKey.from(jdbcSelect.getSql(), executionContext.getQueryOptions().getLimit(), executionContext.getDomainParameterBindingContext().getQueryParameterBindings(), executionContext.getSession());
            cachedResults = queryCache.get(queryResultsCacheKey, jdbcSelect.getAffectedTableNames(), executionContext.getSession());
        } else {
            log.debugf("Skipping reading Query result cache data: cache-enabled = %s, cache-mode = %s", (Object)queryCacheEnabled, (Object)cacheMode.name());
            cachedResults = null;
            queryResultsCacheKey = null;
        }
        if (cachedResults == null || cachedResults.isEmpty()) {
            return new JdbcValuesResultSetImpl(resultSetAccess, queryResultsCacheKey, executionContext.getQueryOptions(), resultSetMapping, executionContext);
        }
        return new JdbcValuesCacheHit(cachedResults, resultSetMapping);
    }

    private CacheMode resolveCacheMode(ExecutionContext executionContext) {
        CacheMode cacheMode = executionContext.getQueryOptions().getCacheMode();
        if (cacheMode != null) {
            return cacheMode;
        }
        cacheMode = executionContext.getSession().getCacheMode();
        if (cacheMode != null) {
            return cacheMode;
        }
        return CacheMode.NORMAL;
    }

    private static enum ExecuteAction {
        EXECUTE_QUERY;

    }
}

