/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.exec.internal;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.model.domain.spi.EntityTypeDescriptor;
import org.hibernate.sql.exec.internal.ResultsConsumer;
import org.hibernate.sql.results.internal.JdbcValuesSourceProcessingStateStandardImpl;
import org.hibernate.sql.results.internal.RowProcessingStateStandardImpl;
import org.hibernate.sql.results.internal.values.JdbcValues;
import org.hibernate.sql.results.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.spi.RowReader;

public class ListResultsConsumer<R>
implements ResultsConsumer<List<R>, R> {
    public static final ListResultsConsumer INSTANCE = new ListResultsConsumer();

    public static <R> ListResultsConsumer<R> instance() {
        return INSTANCE;
    }

    @Override
    public List<R> consume(JdbcValues jdbcValues, SharedSessionContractImplementor session, JdbcValuesSourceProcessingOptions processingOptions, JdbcValuesSourceProcessingStateStandardImpl jdbcValuesSourceProcessingState, RowProcessingStateStandardImpl rowProcessingState, RowReader<R> rowReader) {
        try {
            EntityTypeDescriptor entityDescriptor;
            session.getPersistenceContext().getLoadContexts().register(jdbcValuesSourceProcessingState);
            boolean uniqueRows = false;
            Class<R> resultJavaType = rowReader.getResultJavaType();
            if (resultJavaType != null && !resultJavaType.isArray() && (entityDescriptor = session.getFactory().getMetamodel().findEntityDescriptor(resultJavaType)) != null) {
                uniqueRows = true;
            }
            ArrayList<R> results = new ArrayList<R>();
            while (rowProcessingState.next()) {
                R row = rowReader.readRow(rowProcessingState, processingOptions);
                boolean add = true;
                if (uniqueRows && results.contains(row)) {
                    add = false;
                }
                if (add) {
                    results.add(row);
                }
                rowProcessingState.finishRowProcessing();
            }
            ArrayList<R> arrayList = results;
            return arrayList;
        }
        catch (SQLException e) {
            throw session.getJdbcServices().getSqlExceptionHelper().convert(e, "Error processing return rows");
        }
        finally {
            rowReader.finishUp(jdbcValuesSourceProcessingState);
            jdbcValuesSourceProcessingState.finishUp();
            jdbcValues.finishUp();
        }
    }
}

