/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal;

import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.hibernate.annotations.Remove;
import org.hibernate.bytecode.enhance.spi.LazyPropertyInitializer;
import org.hibernate.metamodel.model.domain.spi.StateArrayContributor;
import org.hibernate.metamodel.model.domain.spi.StateArrayContributorContainer;
import org.hibernate.sql.results.spi.RowProcessingState;
import org.hibernate.sql.results.spi.SqlSelection;
import org.hibernate.sql.results.spi.SqlSelectionGroup;
import org.hibernate.sql.results.spi.SqlSelectionGroupNode;

@Remove
public abstract class AbstractSqlSelectionGroup
implements SqlSelectionGroup {
    private final Map<StateArrayContributor<?>, SqlSelectionGroupNode> selectionNodesByContributor;

    public AbstractSqlSelectionGroup(Map<StateArrayContributor<?>, SqlSelectionGroupNode> selectionNodesByContributor) {
        this.selectionNodesByContributor = selectionNodesByContributor;
    }

    protected abstract StateArrayContributorContainer getContributorContainer();

    @Override
    public Object hydrateStateArray(RowProcessingState currentRowState) {
        List<StateArrayContributor<?>> stateArrayContributors = this.getContributorContainer().getStateArrayContributors();
        Object[] state = new Object[stateArrayContributors.size()];
        stateArrayContributors.forEach(contributor -> {
            SqlSelectionGroupNode selections = this.selectionNodesByContributor.get(contributor);
            Object value = selections == null ? LazyPropertyInitializer.UNFETCHED_PROPERTY : selections.hydrateStateArray(currentRowState);
            state[contributor.getStateArrayPosition()] = value;
        });
        return state;
    }

    @Override
    public void visitSqlSelections(Consumer<SqlSelection> action) {
        this.selectionNodesByContributor.forEach((contributor, sqlSelectionGroupNode) -> sqlSelectionGroupNode.visitSqlSelections(action));
    }
}

