/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal;

import java.util.List;
import java.util.function.Consumer;
import org.hibernate.sql.results.spi.RowProcessingState;
import org.hibernate.sql.results.spi.SqlSelection;
import org.hibernate.sql.results.spi.SqlSelectionGroupNode;

public class AggregateSqlSelectionGroupNode
implements SqlSelectionGroupNode {
    private final List<? extends SqlSelectionGroupNode> subNodes;

    public AggregateSqlSelectionGroupNode(List<? extends SqlSelectionGroupNode> subNodes) {
        this.subNodes = subNodes;
    }

    @Override
    public Object hydrateStateArray(RowProcessingState currentRowState) {
        if (this.subNodes.size() == 0) {
            return null;
        }
        if (this.subNodes.size() == 1) {
            return this.subNodes.get(0).hydrateStateArray(currentRowState);
        }
        Object[] values = new Object[this.subNodes.size()];
        for (int i = 0; i < this.subNodes.size(); ++i) {
            values[i] = this.subNodes.get(i).hydrateStateArray(currentRowState);
        }
        return values;
    }

    @Override
    public void visitSqlSelections(Consumer<SqlSelection> action) {
        this.subNodes.forEach(node -> node.visitSqlSelections(action));
    }
}

