/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal;

import java.util.function.Consumer;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.metamodel.model.domain.spi.Navigable;
import org.hibernate.query.NavigablePath;
import org.hibernate.sql.results.spi.AssemblerCreationState;
import org.hibernate.sql.results.spi.BiDirectionalFetch;
import org.hibernate.sql.results.spi.DomainResultAssembler;
import org.hibernate.sql.results.spi.Fetch;
import org.hibernate.sql.results.spi.FetchParent;
import org.hibernate.sql.results.spi.FetchParentAccess;
import org.hibernate.sql.results.spi.Initializer;
import org.hibernate.sql.results.spi.JdbcValuesSourceProcessingOptions;
import org.hibernate.sql.results.spi.RowProcessingState;
import org.hibernate.type.descriptor.java.spi.JavaTypeDescriptor;

public class BiDirectionalFetchImpl
implements BiDirectionalFetch {
    private final FetchParent referencedFetchParent;
    private final NavigablePath navigablePath;

    public BiDirectionalFetchImpl(FetchParent referencedFetch, NavigablePath navigablePath) {
        if (referencedFetch instanceof BiDirectionalFetch) {
            referencedFetch = ((BiDirectionalFetch)((Object)referencedFetch)).getFetchParent();
        }
        this.referencedFetchParent = referencedFetch;
        this.navigablePath = navigablePath;
    }

    @Override
    public FetchParent getFetchParent() {
        return this.referencedFetchParent;
    }

    @Override
    public Navigable getFetchedNavigable() {
        return this.referencedFetchParent.getNavigableContainer();
    }

    @Override
    public String getFetchedNavigableName() {
        return this.navigablePath.getLocalName();
    }

    @Override
    public NavigablePath getNavigablePath() {
        return this.navigablePath;
    }

    @Override
    public boolean isNullable() {
        throw new NotYetImplementedFor6Exception(this.getClass());
    }

    Fetch getFetch() {
        return this;
    }

    @Override
    public DomainResultAssembler createAssembler(FetchParentAccess parentAccess, Consumer<Initializer> collector, AssemblerCreationState creationState) {
        return new CircularFetchAssembler(this.referencedFetchParent.getNavigablePath(), (JavaTypeDescriptor)this.referencedFetchParent.getNavigableContainer().getJavaTypeDescriptor());
    }

    private static class CircularFetchAssembler
    implements DomainResultAssembler {
        private final NavigablePath circularPath;
        private final JavaTypeDescriptor javaTypeDescriptor;

        public CircularFetchAssembler(NavigablePath circularPath, JavaTypeDescriptor javaTypeDescriptor) {
            this.circularPath = circularPath;
            this.javaTypeDescriptor = javaTypeDescriptor;
        }

        @Override
        public Object assemble(RowProcessingState rowProcessingState, JdbcValuesSourceProcessingOptions options) {
            return rowProcessingState.resolveInitializer(this.circularPath).getInitializedInstance();
        }

        @Override
        public JavaTypeDescriptor getJavaTypeDescriptor() {
            return this.javaTypeDescriptor;
        }
    }
}

