/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.hibernate.NotYetImplementedFor6Exception;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.query.NavigablePath;
import org.hibernate.query.spi.QueryOptions;
import org.hibernate.sql.ast.produce.sqm.spi.Callback;
import org.hibernate.sql.exec.spi.DomainParameterBindingContext;
import org.hibernate.sql.results.internal.JdbcValuesSourceProcessingStateStandardImpl;
import org.hibernate.sql.results.internal.values.JdbcValues;
import org.hibernate.sql.results.spi.EntityFetch;
import org.hibernate.sql.results.spi.Initializer;
import org.hibernate.sql.results.spi.JdbcValuesSourceProcessingState;
import org.hibernate.sql.results.spi.RowProcessingState;
import org.hibernate.sql.results.spi.RowReader;
import org.hibernate.sql.results.spi.SqlSelection;
import org.jboss.logging.Logger;

public class RowProcessingStateStandardImpl
implements RowProcessingState {
    private static final Logger log = Logger.getLogger(RowProcessingStateStandardImpl.class);
    private final JdbcValuesSourceProcessingStateStandardImpl resultSetProcessingState;
    private final QueryOptions queryOptions;
    private final Map<NavigablePath, Initializer> initializerMap;
    private final JdbcValues jdbcValues;
    private Object[] currentRowJdbcValues;

    public RowProcessingStateStandardImpl(JdbcValuesSourceProcessingStateStandardImpl resultSetProcessingState, QueryOptions queryOptions, RowReader<?> rowReader, JdbcValues jdbcValues) {
        this.resultSetProcessingState = resultSetProcessingState;
        this.queryOptions = queryOptions;
        this.jdbcValues = jdbcValues;
        List<Initializer> initializers = rowReader.getInitializers();
        if (initializers == null || initializers.isEmpty()) {
            this.initializerMap = null;
        } else {
            this.initializerMap = new HashMap<NavigablePath, Initializer>();
            for (Initializer initializer : initializers) {
                this.initializerMap.put(initializer.getNavigablePath(), initializer);
            }
        }
    }

    @Override
    public JdbcValuesSourceProcessingState getJdbcValuesSourceProcessingState() {
        return this.resultSetProcessingState;
    }

    public boolean next() throws SQLException {
        if (this.jdbcValues.next(this)) {
            this.currentRowJdbcValues = this.jdbcValues.getCurrentRowValuesArray();
            return true;
        }
        this.currentRowJdbcValues = null;
        return false;
    }

    @Override
    public Object getJdbcValue(SqlSelection sqlSelection) {
        return this.currentRowJdbcValues[sqlSelection.getValuesArrayPosition()];
    }

    @Override
    public void registerNonExists(EntityFetch fetch) {
    }

    @Override
    public void finishRowProcessing() {
        this.currentRowJdbcValues = null;
    }

    @Override
    public SharedSessionContractImplementor getSession() {
        return this.getJdbcValuesSourceProcessingState().getExecutionContext().getSession();
    }

    @Override
    public QueryOptions getQueryOptions() {
        return this.queryOptions;
    }

    @Override
    public DomainParameterBindingContext getDomainParameterBindingContext() {
        throw new NotYetImplementedFor6Exception();
    }

    @Override
    public Callback getCallback() {
        return afterLoadAction -> {};
    }

    @Override
    public Initializer resolveInitializer(NavigablePath path) {
        return this.initializerMap == null ? null : this.initializerMap.get(path);
    }
}

